---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：25-bun_outdated.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **--updateオプション**: 実装詳細要確認
  2. **並列問い合わせ**: 実装詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/outdated_command.zig` - outdatedコマンド実装
- E-02: `src/install/PackageManager.zig` - パッケージマネージャー
- E-03: `src/install/lockfile.zig` - lockfile読み込み
- E-04: `src/Semver.zig` - セマンティックバージョン
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun outdatedは更新可能なパッケージを表示 | E-01 | ○ |
| C-02 | lockfileから依存パッケージを抽出 | E-01, E-03 | ○ |
| C-03 | npmレジストリに問い合わせ | E-01 | ○ |
| C-04 | Current/Wanted/Latestのバージョン比較 | E-01 | ○ |
| C-05 | テーブル形式とJSON形式の出力 | E-01 | ○ |
| C-06 | ワークスペース対応 | E-01 | ○ |
| C-07 | lockfile必須 | E-01 | ○ |
| C-08 | Wantedはpackage.json範囲内の最新 | E-01, E-04 | ○ |
| C-09 | Latestはdist-tag latestのバージョン | E-01 | ○ |
| C-10 | パッケージ名で指定パッケージのみフィルタ | E-01 | ○ |
| C-11 | 関連画面No.17 outdated | E-06 (56行目) | ○ |
| C-12 | 機能No.25 bun outdated | E-05 (26行目) | ○ |
| C-13 | Semver.Query.satisfiesでバージョンマッチ | E-04 | ○ |
| C-14 | HTTPSによる通信暗号化 | E-01 (暗黙的) | ○ |
| C-15 | npm outdated互換の出力形式 | E-01 (形式から推測) | ○ |
| C-16 | PackageManager.initで初期化 | E-01, E-02 | ○ |
| C-17 | --updateオプションでbun update実行 | **根拠不足** | △ |
| C-18 | 並列問い合わせで効率化 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: --updateオプションの実装詳細
  - 候補：ソースコードの詳細確認 / ドキュメント
- C-18: 並列問い合わせの実装
  - 候補：ネットワーク処理のソースコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 1: 中リスク - --updateオプションの詳細は要確認
- 1: 中リスク - パフォーマンス最適化の詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-17: --updateオプションの実装を確認
- [ ] C-18: レジストリ問い合わせの並列化を確認
- [ ] 出力テーブルの列名がnpm outdatedと一致しているか確認
- [ ] ワークスペース環境での出力形式を確認
