---
generated_at: 2026-01-27 17:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：26-bun_audit.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **--fixオプション**: 実装詳細要確認
  2. **重要度分類の詳細**: 実装詳細要確認
  3. **CI/CD終了コード**: 実装詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/audit_command.zig` - auditコマンド実装
- E-02: `src/install/PackageManager.zig` - パッケージマネージャー
- E-03: `src/install/lockfile.zig` - lockfile読み込み
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun auditは脆弱性をチェック | E-01 | ○ |
| C-02 | lockfileからパッケージリストを抽出 | E-01, E-03 | ○ |
| C-03 | 脆弱性データベースに問い合わせ | E-01 | ○ |
| C-04 | critical/high/moderate/lowの4段階 | E-01 | ○ |
| C-05 | JSON形式とサマリー形式の出力 | E-01 | ○ |
| C-06 | lockfile必須 | E-01 | ○ |
| C-07 | --productionでdevDependencies除外 | E-01 | ○ |
| C-08 | --levelでフィルタリング | E-01 | ○ |
| C-09 | HTTPSによる通信 | E-01 (暗黙的) | ○ |
| C-10 | 関連画面No.18 audit | E-05 (57行目) | ○ |
| C-11 | 機能No.26 bun audit | E-04 (27行目) | ○ |
| C-12 | PackageManager.initで初期化 | E-01, E-02 | ○ |
| C-13 | lockfile.loadFromCwdで読み込み | E-01, E-03 | ○ |
| C-14 | npm audit互換の出力形式 | E-01 (形式から推測) | ○ |
| C-15 | 数秒から数十秒で完了 | E-01 (経験則) | ○ |
| C-16 | --fixオプションで自動修正 | **根拠不足** | △ |
| C-17 | 重要度分類の詳細定義 | **根拠不足** | △ |
| C-18 | CI/CD終了コード | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: --fixオプションの実装詳細
  - 候補：ソースコードの詳細確認 / ドキュメント
- C-17: 重要度分類の詳細定義
  - 候補：npm脆弱性DBの仕様 / CVSS基準
- C-18: CI/CD終了コード
  - 候補：実装確認 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 1: 中リスク - --fixオプションの詳細は要確認
- 1: 中リスク - 重要度分類の基準は要確認
- 1: 中リスク - CI/CD終了コードは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-16: --fixオプションの実装を確認
- [ ] C-17: 重要度分類の基準を確認
- [ ] C-18: CI/CD終了コードの仕様を確認
- [ ] npm audit APIとの互換性を確認
