---
generated_at: 2026-01-27 17:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：27-bun_pm.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **npm/pnpm/yarn互換性**: 詳細な互換性検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/package_manager_command.zig` - pmコマンド実装
- E-02: `src/cli/pm_why_command.zig` - whyサブコマンド
- E-03: `src/cli/pm_view_command.zig` - viewサブコマンド
- E-04: `src/cli/pm_version_command.zig` - versionサブコマンド
- E-05: `src/cli/pm_pkg_command.zig` - pkgサブコマンド
- E-06: `src/cli/pm_trusted_command.zig` - trust関連サブコマンド
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun pmは複数のサブコマンドを提供 | E-01 (78-131行目ヘルプ) | ○ |
| C-02 | exec関数がエントリーポイント | E-01 (138行目) | ○ |
| C-03 | getSubcommandでサブコマンド特定 | E-01 (58-76行目) | ○ |
| C-04 | binサブコマンドでbinパス表示 | E-01 (199-224行目) | ○ |
| C-05 | -gでグローバルbinパス | E-01 (206-221行目) | ○ |
| C-06 | cacheサブコマンドでキャッシュ操作 | E-01 (251-308行目) | ○ |
| C-07 | cache rmでキャッシュクリア | E-01 (259-304行目) | ○ |
| C-08 | hashサブコマンドでハッシュ生成 | E-01 (225-235行目) | ○ |
| C-09 | lsサブコマンドで依存関係表示 | E-01 (318-397行目) | ○ |
| C-10 | --allで全依存関係表示 | E-01 (360行目) | ○ |
| C-11 | migrateサブコマンドでlockfile移行 | E-01 (400-435行目) | ○ |
| C-12 | whoamiでnpmユーザー名取得 | E-01 (178-194行目) | ○ |
| C-13 | viewでパッケージ情報表示 | E-01 (195-198行目) | ○ |
| C-14 | versionでバージョン更新 | E-01 (436-438行目) | ○ |
| C-15 | whyで依存理由表示 | E-01 (439-441行目) | ○ |
| C-16 | pkgでpackage.json管理 | E-01 (442-444行目) | ○ |
| C-17 | trustで信頼管理 | E-01 (315-317行目) | ○ |
| C-18 | untrustedで未信頼表示 | E-01 (312-314行目) | ○ |
| C-19 | default-trustedでデフォルトリスト表示 | E-01 (309-311行目) | ○ |
| C-20 | scanでセキュリティスキャン | E-01 (172-174行目) | ○ |
| C-21 | packでtarball作成 | E-01 (175-177行目) | ○ |
| C-22 | 関連画面No.19 pm | E-08 (58-61行目) | ○ |
| C-23 | 機能No.27 bun pm | E-07 (28行目) | ○ |
| C-24 | printNodeModulesFolderStructureでツリー表示 | E-01 (460-587行目) | ○ |
| C-25 | npm/pnpm/yarn互換 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: 他のパッケージマネージャーとの互換性詳細
  - 候補：比較テスト / 互換性ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 0: 低リスク - サブコマンドの一覧は正確
- 1: 中リスク - 他のパッケージマネージャーとの互換性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-25: npm/pnpm/yarnとの互換性を確認
- [ ] 全サブコマンドのヘルプ出力が正確か確認
- [ ] エラーメッセージが適切か確認
