---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-bun_why.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。軽微な確認のみ。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/why_command.zig` - whyコマンド実装
- E-02: `src/cli/pm_why_command.zig` - pm why経由の実装
- E-03: `src/install/lockfile.zig` - lockfile読み込み
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun whyは依存元を表示 | E-01 (1行目コメント) | ○ |
| C-02 | DependentInfo構造体で依存元情報管理 | E-01 (13-19行目) | ○ |
| C-03 | DependencyType enumで依存種別定義 | E-01 (22-28行目) | ○ |
| C-04 | GlobPattern構造体でパターンマッチ | E-01 (72-188行目) | ○ |
| C-05 | exec関数がエントリーポイント | E-01 (213行目) | ○ |
| C-06 | execWithManager関数がメイン処理 | E-01 (242行目) | ○ |
| C-07 | lockfileの読み込み | E-01 (243行目) | ○ |
| C-08 | --topで深さ1 | E-01 (246-247行目) | ○ |
| C-09 | --depthで深さ指定 | E-01 (248-249行目) | ○ |
| C-10 | デフォルト深さ100 | E-01 (6行目, 250-251行目) | ○ |
| C-11 | 逆依存関係マップの構築 | E-01 (272行目) | ○ |
| C-12 | glob検索のサポート | E-01 (72-188行目, GlobPattern) | ○ |
| C-13 | バージョン指定のサポート | E-01 (88-100行目) | ○ |
| C-14 | 循環依存の検出 | E-01 (437-439行目, *circular) | ○ |
| C-15 | 依存種別の表示 | E-01 (380-386行目) | ○ |
| C-16 | printPackageWithType関数 | E-01 (377行目) | ○ |
| C-17 | printDependencyTree関数 | E-01 (429行目) | ○ |
| C-18 | compareDependentsでソート | E-01 (52-70行目) | ○ |
| C-19 | ワークスペースは青色表示 | E-01 (389行目, blue) | ○ |
| C-20 | 循環依存は黄色表示 | E-01 (438行目, yellow) | ○ |
| C-21 | 関連画面No.20 why | E-05 (62-63行目) | ○ |
| C-22 | 機能No.28 bun why | E-04 (29行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主要機能が実装と一致

## 6) レビュアーチェックリスト（最小）
- [ ] ツリー表示の見やすさを実際の出力で確認
- [ ] 大規模依存関係でのパフォーマンスを確認
- [ ] glob検索の各パターンが正しく動作するか確認
