---
generated_at: 2026-01-27 17:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-トランスパイラ.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **トランスパイル速度の具体的数値**：ベンチマーク根拠が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `src/transpiler.zig` - トランスパイラメイン実装
- E-02: `src/js_parser.zig` - JavaScriptパーサー
- E-03: `src/js_lexer.zig` - 字句解析器
- E-04: `src/js_printer.zig` - コード生成器
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TypeScript、JSX、TSXをネイティブでトランスパイル | E-05 (機能一覧.csv No.3) | ○ |
| C-02 | src/transpiler.zig、src/js_parser.zigで実装 | E-05 (機能一覧.csv No.3備考) | ○ |
| C-03 | ParseResult構造体でパース結果を管理 | E-01 (transpiler.zig 7-56行目) | ○ |
| C-04 | AlreadyBundled enumでバイトコードキャッシュ | E-01 (transpiler.zig 18-39行目) | ○ |
| C-05 | PluginRunnerでプラグイン処理 | E-01 (transpiler.zig 58-185行目) | ○ |
| C-06 | パーサー変更時はRuntimeTranspilerCacheバージョン更新 | E-02 (js_parser.zig 1-5行目コメント) | ○ |
| C-07 | JSXImport enumでJSX関連シンボル管理 | E-02 (js_parser.zig 37-99行目) | ○ |
| C-08 | P/p.e/p.b/p.sの省略記法 | E-02 (js_parser.zig 104-116行目コメント) | ○ |
| C-09 | 型チェックは行わず型情報のみ削除 | E-02 (ビジネスロジック) | ○ |
| C-10 | React 17+ automatic JSXランタイムサポート | E-02 (JSXImport enum) | ○ |
| C-11 | 画面No.1「run」と関連 | E-06 (画面機能マッピング.csv) | ○ |
| C-12 | TypeScript型パラメータスキップ処理 | E-02 (js_parser.zig 18-22行目) | ○ |
| C-13 | bytecode/bytecode_cjsでESM/CJS区別 | E-01 (AlreadyBundled enum) | ○ |
| C-14 | Zigで実装された高速パーサー | E-01, E-02 (Zigソースコード) | ○ |
| C-15 | ソースマップ生成オプション | E-05 (--sourcemapオプション記載) | ○ |
| C-16 | 1000行あたり10ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランスパイル速度の具体的数値は公式ベンチマークまたは内部テスト結果からの引用が必要
  - 候補：公式ドキュメント / esbuildとの比較ベンチマーク / CI

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：機能概要、処理フロー、コードリーディングガイドは十分な根拠あり
- 1（中リスク）：パフォーマンス要件の数値は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] トランスパイル速度の数値が妥当か確認
- [ ] TypeScript型削除の範囲が正確か確認（decorators等）
- [ ] JSXランタイム設定のデフォルト値が正しいか確認
