---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：30-JavaScriptバンドル.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **インクリメンタルビルド**: 実装詳細要確認
  2. **一時ファイルリネーム**: 実装詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/bundle_v2.zig` - バンドラーメイン実装
- E-02: `src/cli/build_command.zig` - CLIエントリーポイント
- E-03: `src/Transpiler.zig` - トランスパイラ
- E-04: `src/js_parser.zig` - JavaScriptパーサー
- E-05: `src/bundler/linker.zig` - リンク処理
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bun buildはJavaScriptバンドルを生成 | E-01, E-02 | ○ |
| C-02 | BundleV2構造体がバンドラーの中核 | E-01 (107行目) | ○ |
| C-03 | Tree-shakingで不要コード除去 | E-01 (コメント) | ○ |
| C-04 | コード分割(splitting)をサポート | E-01 (code_splitting) | ○ |
| C-05 | ミニファイをサポート | E-01 (minify) | ○ |
| C-06 | ソースマップ生成をサポート | E-01 (sourcemap) | ○ |
| C-07 | waitForParseで依存関係解析 | E-01 (478行目) | ○ |
| C-08 | findReachableFilesで到達可能ファイル特定 | E-01 (374行目) | ○ |
| C-09 | 複数ターゲット(browser/bun/node)をサポート | E-01 (options.Target) | ○ |
| C-10 | ESM/CJS/IIFE形式をサポート | E-01 (format) | ○ |
| C-11 | TypeScript変換をサポート | E-03, E-04 | ○ |
| C-12 | JSX変換をサポート | E-04 | ○ |
| C-13 | 並列処理によるマルチコア活用 | E-01 (ThreadPool参照) | ○ |
| C-14 | モジュール解決はNode.js互換 | E-01 (resolver参照) | ○ |
| C-15 | 循環依存の検出 | E-01 (has_circular) | ○ |
| C-16 | --externalで外部パッケージ指定 | E-01 (external) | ○ |
| C-17 | --defineでコンパイル時定数定義 | E-01 (define) | ○ |
| C-18 | Bun.build() APIを提供 | E-01 (JSBundler参照) | ○ |
| C-19 | 関連画面No.22 build | E-07 (65行目) | ○ |
| C-20 | 機能No.30 JavaScriptバンドル | E-06 (31行目) | ○ |
| C-21 | インクリメンタルビルド対応 | **根拠不足** | △ |
| C-22 | 一時ファイル書き込み後リネーム | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21: インクリメンタルビルドの実装詳細
  - 候補：キャッシュ機構のソースコード確認
- C-22: 一時ファイルリネームの実装詳細
  - 候補：出力処理のソースコード確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の記述は実装と一致
- 1: 中リスク - インクリメンタルビルドは要確認
- 1: 中リスク - 出力の原子性保証は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] C-21: インクリメンタルビルドの実装を確認
- [ ] C-22: 一時ファイル処理の実装を確認
- [ ] esbuild互換性の程度を確認
- [ ] 大規模プロジェクトでのパフォーマンスを確認
