---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：31-ツリーシェイキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件「大規模プロジェクトでも数秒以内」**：具体的なベンチマーク根拠なし
  2. **sideEffects フィールドの処理詳細**：package.json解析コードの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/LinkerContext.zig` 59-64行目 - LinkerOptionsのtree_shaking定義
- E-02: `src/bundler/bundle_v2.zig` 269-462行目 - findReachableFiles()実装
- E-03: `src/bundler/linker_context/scanImportsAndExports.zig` 1-200行目 - インポート/エクスポート解析
- E-04: `src/bundler/linker_context/doStep5.zig` 1-200行目 - パート依存関係計算
- E-05: `src/cli/build_command.zig` 79-80行目 - emit_dce_annotations, ignore_dce_annotationsオプション
- E-06: `src/cli/build_command.zig` 94-95行目 - DevServer時のtree_shaking無効化
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 31行目 - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 65行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ツリーシェイキングはデフォルトで有効 | E-01 | ○ |
| C-02 | ESモジュールの静的解析でインポート/エクスポート関係を把握 | E-03 | ○ |
| C-03 | findReachableFiles()で到達可能ファイルを特定 | E-02 | ○ |
| C-04 | doStep5()でパート依存関係を計算 | E-04 | ○ |
| C-05 | tree_shakingオプションで有効/無効を切り替え可能 | E-01 | ○ |
| C-06 | ignore_dce_annotationsオプションが存在 | E-01, E-05 | ○ |
| C-07 | emit_dce_annotationsオプションが存在 | E-01, E-05 | ○ |
| C-08 | DevServer使用時はツリーシェイキングが無効化 | E-06 | ○ |
| C-09 | CommonJSモジュールはツリーシェイキングが制限される | E-03 | ○ |
| C-10 | シンボル使用回数(count_estimate)を追跡 | E-04 | ○ |
| C-11 | TypeScript enumのインライン化処理 | E-04 | ○ |
| C-12 | code_splitting有効時の動的インポートチェック | E-02 | ○ |
| C-13 | 副作用(sideEffects)の考慮 | E-03 | ○ |
| C-14 | ReachableFileVisitorがファイル走査を行う | E-02 | ○ |
| C-15 | 画面No.20(build)が関連画面 | E-07, E-08 | ○ |
| C-16 | スレッドプールを活用した並列処理 | E-04 | ○ |
| C-17 | 大規模プロジェクトでも数秒以内で完了 | **根拠なし** | △ |
| C-18 | package.jsonのsideEffectsフィールドを参照 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的なベンチマーク結果
  - 候補：ベンチマークテスト結果 / CI性能テスト / ドキュメント
- sideEffectsフィールド解析の詳細実装箇所
  - 候補：`src/resolver/` 配下 / `src/bundler/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: パフォーマンス要件は実測値で確認推奨
- 0: sideEffectsの詳細実装は別途コード確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] LinkerContext.zigのtree_shakingデフォルト値を確認
- [ ] DevServer時の無効化ロジックを確認
- [ ] パフォーマンス要件の妥当性を検討
- [ ] sideEffectsフィールドの解析箇所を特定
