---
generated_at: 2026-01-27 17:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-コード分割

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **循環動的インポート検出時の警告処理**：具体的なエラーハンドリングコードの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/Chunk.zig` 1-100行目 - Chunk構造体、entry_bits、cross_chunk_imports定義
- E-02: `src/bundler/bundle_v2.zig` 293-428行目 - findReachableFiles()、動的インポート検出
- E-03: `src/bundler/linker_context/computeChunks.zig` 1-300行目 - チャンク計算処理
- E-04: `src/cli/build_command.zig` 74行目 - code_splittingオプション設定
- E-05: `src/cli/build_command.zig` 159-163行目 - outdir必須チェック
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 32行目 - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 66行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 動的インポート(import())によるチャンク分割 | E-02 | ○ |
| C-02 | code_splittingオプションで有効化 | E-04 | ○ |
| C-03 | outdir必須（splitting有効時） | E-05 | ○ |
| C-04 | entry_bitsでエントリーポイント到達可能性を管理 | E-01, E-03 | ○ |
| C-05 | cross_chunk_importsでチャンク間依存関係を管理 | E-01 | ○ |
| C-06 | 複数エントリーから参照されるモジュールは共有チャンク | E-03 | ○ |
| C-07 | チャンクキーはエントリービットのバイト表現 | E-03 | ○ |
| C-08 | code_splitting時のみ動的インポートをチェック | E-02 | ○ |
| C-09 | チャンク生成は並列処理 | E-03 | ○ |
| C-10 | CSSチャンキングと組み合わせ可能 | E-03 | ○ |
| C-11 | AutoBitSetでビットセット管理 | E-01, E-03 | ○ |
| C-12 | computeChunks()でチャンク計算 | E-03 | ○ |
| C-13 | 動的エントリーポイントとして登録 | E-02 | ○ |
| C-14 | ハッシュ付き命名がデフォルト | E-03 | ○ |
| C-15 | 画面No.20(build)が関連画面 | E-06, E-07 | ○ |
| C-16 | 循環動的インポート検出時に警告 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- 循環動的インポート検出時の警告処理の詳細
  - 候補：`src/bundler/` 配下のエラーハンドリングコード

## 5) リスクフラグ（レビュー観点）
- 0: 循環動的インポートのエラーハンドリングは別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Chunk.zigのentry_bitsフィールドを確認
- [ ] computeChunks.zigのチャンク計算ロジックを確認
- [ ] outdir必須チェックのエラーメッセージを確認
- [ ] 動的インポート検出ロジックを確認
