---
generated_at: 2026-01-27 17:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：33-CSSバンドル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **@tailwindカスタムルールの専用処理**：具体的な実装箇所の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/css/css_parser.zig` 1-200行目 - CSSパーサー構造、型定義
- E-02: `src/css/css_modules.zig` - CSS Modules処理
- E-03: `src/css/prefixes.zig` - ベンダープレフィックス処理
- E-04: `src/bundler/linker_context/scanImportsAndExports.zig` 41-78行目 - CSSインポートスキャン、composes検証
- E-05: `src/bundler/linker_context/computeChunks.zig` 81-118行目 - CSSチャンク計算
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 33行目 - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 67行目 - 画面マッピング
- E-08: `src/css/rules/tailwind.zig` - Tailwindルール処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | css_parser.zigでCSSをパース | E-01 | ○ |
| C-02 | CSS Modulesのスコープ処理 | E-02 | ○ |
| C-03 | ベンダープレフィックスの自動追加 | E-03 | ○ |
| C-04 | css_chunkingオプションでチャンキング制御 | E-05 | ○ |
| C-05 | findImportedFilesInCSSOrder()でインポート順序計算 | E-05 | ○ |
| C-06 | composes検証でクラス存在確認 | E-04 | ○ |
| C-07 | VendorPrefix構造体でプレフィックス管理 | E-01 | ○ |
| C-08 | CssRule、CssRuleListの型定義 | E-01 | ○ |
| C-09 | JSからインポートされたCSSを自動検出 | E-05 | ○ |
| C-10 | .module.cssでCSS Modules判定 | E-02 | ○ |
| C-11 | 画面No.20(build)が関連画面 | E-06, E-07 | ○ |
| C-12 | @import順序に基づくファイル結合 | E-05 | ○ |
| C-13 | ソースマップ生成対応 | E-01 | ○ |
| C-14 | ターゲットブラウザに応じたプレフィックス | E-03 | ○ |
| C-15 | @tailwindカスタムルールの専用処理 | E-08 | △ |

## 4) 不足情報（Unknown / Missing）
- @tailwind処理の詳細実装確認
  - 候補：`src/css/rules/tailwind.zig` の詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: Tailwind処理は別途詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] css_parser.zigのパース処理フローを確認
- [ ] CSS Modulesのクラス名ハッシュ化ロジックを確認
- [ ] composes検証のエラーメッセージを確認
- [ ] ベンダープレフィックスの追加条件を確認
