---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-HTMLバンドル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/HTMLImportManifest.zig` 1-200行目 - マニフェスト構造、生成ロジック
- E-02: `src/bundler/linker_context/computeChunks.zig` 64-79行目 - HTMLチャンク作成
- E-03: `src/cli/build_command.zig` 143-150行目 - --no-bundleでHTMLインポートエラー
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 34行目 - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 68行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLImportManifestでマニフェスト生成 | E-01 | ○ |
| C-02 | マニフェストにindex、filesを含む | E-01 | ○ |
| C-03 | filesにinput、path、loader、isEntry、headersを含む | E-01 | ○ |
| C-04 | headersにETag、Content-Typeを含む | E-01 | ○ |
| C-05 | HTMLチャンク(content = .html)の判定 | E-02 | ○ |
| C-06 | has_html_chunkフラグでHTMLチャンク識別 | E-02 | ○ |
| C-07 | html_chunksマップでHTMLチャンク管理 | E-02 | ○ |
| C-08 | --no-bundleでHTMLインポートエラー | E-03 | ○ |
| C-09 | アセット参照の最終パス更新 | E-01 | ○ |
| C-10 | ETagにコンテンツハッシュ使用 | E-01 | ○ |
| C-11 | 画面No.20(build)が関連画面 | E-04, E-05 | ○ |
| C-12 | JSからHTMLインポート時にマニフェスト取得 | E-01 | ○ |
| C-13 | loaderにjs, css, html, file等の値 | E-01 | ○ |
| C-14 | 公開パス(public_path)のプレフィックス対応 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全項目に根拠あり、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] HTMLImportManifest.zigのマニフェスト構造を確認
- [ ] ETag生成ロジックを確認
- [ ] --no-bundleエラーメッセージを確認
