---
generated_at: 2026-01-27 17:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：35-単一実行ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **StandaloneModuleGraph.zigの詳細確認**：埋め込み処理の実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/build_command.zig` 22, 54, 100-140行目 - compileオプション処理
- E-02: `src/cli/build_command.zig` 101-105行目 - --outdir併用エラー
- E-03: `src/cli/build_command.zig` 129-133行目 - bun/bunx名禁止
- E-04: `src/cli/build_command.zig` 135-139行目 - --no-bundle併用エラー
- E-05: `src/cli/build_command.zig` 107-110行目 - base_public_path計算
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 35行目 - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 69行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --compileオプションでコンパイルモード有効化 | E-01 | ○ |
| C-02 | --compileと--outdirは併用不可 | E-02 | ○ |
| C-03 | 出力ファイル名にbun/bunxは使用不可 | E-03 | ○ |
| C-04 | --compileと--no-bundle併用不可 | E-04 | ○ |
| C-05 | base_public_pathがStandaloneModuleGraphで計算 | E-05 | ○ |
| C-06 | outfile未指定時はエントリーポイント名使用 | E-01 | ○ |
| C-07 | indexという名前の場合はディレクトリ名を使用 | E-01 | ○ |
| C-08 | クロスコンパイル対応（--target） | E-01 | ○ |
| C-09 | --bytecodeでバイトコードキャッシュ埋め込み | E-01 | ○ |
| C-10 | compile時のdefine自動設定 | E-01 | ○ |
| C-11 | 画面No.20(build)が関連画面 | E-06, E-07 | ○ |
| C-12 | target=bunが設定される | E-01 | ○ |
| C-13 | argv[0]がbun/bunxの場合スタンドアロンチェックスキップ | E-03 | ○ |
| C-14 | StandaloneModuleGraphで埋め込み処理 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- StandaloneModuleGraph.zigの詳細実装確認
  - 候補：`src/standalone/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: StandaloneModuleGraphの詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] --compileオプションのバリデーションを確認
- [ ] 禁止ファイル名のエラーメッセージを確認
- [ ] base_public_path計算ロジックを確認
- [ ] StandaloneModuleGraph.zigの埋め込み処理を確認
