---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：36-ソースマップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **debugIdオプションの詳細**：具体的な実装箇所の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/sourcemap/sourcemap.zig` 1-200行目 - SourceMap構造、SourceMapState、パース処理
- E-02: `src/bundler/LinkerContext.zig` 71行目 - source_mapsオプション定義
- E-03: `src/bundler/LinkerContext.zig` 85-172行目 - SourceMapData構造、計算処理
- E-04: `src/bundler/LinkerContext.zig` 259-289行目 - computeDataForSourceMap()
- E-05: `src/cli/build_command.zig` 52行目 - source_map設定
- E-06: `src/cli/build_command.zig` 56-59行目 - external時のoutdir必須チェック
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 36行目 - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 70行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceMapState構造体で相対オフセット管理 | E-01 | ○ |
| C-02 | 5つの値（generated_line等）を追跡 | E-01 | ○ |
| C-03 | computeLineOffsets()で行オフセット計算 | E-03 | ○ |
| C-04 | computeQuotedSourceContents()でソース引用生成 | E-03 | ○ |
| C-05 | computeDataForSourceMap()で並列処理 | E-04 | ○ |
| C-06 | source_mapsオプションでモード指定 | E-02 | ○ |
| C-07 | external時は--outdir必須 | E-06 | ○ |
| C-08 | LineOffsetTable.generate()で行オフセット生成 | E-03 | ○ |
| C-09 | line_offset_tasks、quoted_contents_tasksで並列タスク | E-04 | ○ |
| C-10 | 画面No.20(build)が関連画面 | E-07, E-08 | ○ |
| C-11 | SourceMapOption型（none, linked, inline, external） | E-02 | ○ |
| C-12 | VLQエンコードでマッピング情報を圧縮 | E-01 | ○ |
| C-13 | sourcesContentに元ソースコード含む | E-01 | ○ |
| C-14 | DevServer時インクリメンタルビルド対応 | E-03 | ○ |
| C-15 | debugIdオプションで一意ID付与 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- debugIdオプションの詳細実装箇所
  - 候補：`src/bundler/` 配下 / `src/sourcemap/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: debugId機能は別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] SourceMapState構造体の5つのフィールドを確認
- [ ] computeLineOffsets()の並列処理を確認
- [ ] external時のoutdir必須チェックを確認
- [ ] VLQエンコードのロジックを確認
