---
generated_at: 2026-01-27 18:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：37-マクロ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **MacroContext詳細実装**：具体的な実装ファイルの確認が必要
  2. **シリアライズ処理の詳細**：戻り値のシリアライズ実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/bundle_v2.zig` 221行目 - macro_contextの初期化
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 37行目 - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 71行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | macro_contextでマクロ実行コンテキスト管理 | E-01 | ○ |
| C-02 | with { type: 'macro' } でマクロインポート指定 | E-02 | ○ |
| C-03 | ビルド時にコードを実行 | E-02 | ○ |
| C-04 | コンパイル時評価機能 | E-02 | ○ |
| C-05 | 画面No.20(build)が関連画面 | E-02, E-03 | ○ |
| C-06 | JavaScriptCoreでマクロ実行 | E-01 | ○ |
| C-07 | 戻り値をJavaScriptリテラルに変換 | E-02 | ○ |
| C-08 | マクロ呼び出しを置換 | E-02 | ○ |
| C-09 | シリアライズ可能な値のみサポート | E-02 | ○ |
| C-10 | 同期的に実行される | E-02 | ○ |
| C-11 | MacroContextの詳細実装 | **詳細確認要** | △ |
| C-12 | シリアライズ処理の詳細 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- MacroContextの詳細実装ファイル
  - 候補：`src/js_ast/` 配下 / `src/bun.js/api/` 配下
- シリアライズ処理の詳細実装
  - 候補：`src/js_ast/` 配下

## 5) リスクフラグ（レビュー観点）
- 1: マクロ機能は実装詳細の確認が推奨
- 0: 機能概要は機能一覧から確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] macro_contextの初期化を確認
- [ ] MacroContextの実装ファイルを特定
- [ ] シリアライズ処理の実装を確認
- [ ] with { type: 'macro' } の解析処理を確認
