---
generated_at: 2026-01-27 18:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：38-ローダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Bun.plugin() APIによる動的ローダー追加**：詳細実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bundler/bundle_v2.zig` 274行目 - all_loaders参照
- E-02: `src/bundler/linker_context/scanImportsAndExports.zig` 314-351行目 - ローダーに応じた処理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 38行目 - 機能定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 72行目 - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル拡張子からローダータイプ判定 | E-01 | ○ |
| C-02 | JavaScript/TypeScriptのトランスパイル | E-03 | ○ |
| C-03 | JSONファイルのパースとインライン化 | E-03 | ○ |
| C-04 | テキストファイルの文字列インポート | E-03 | ○ |
| C-05 | fileローダーでファイルコピー+URL | E-03 | ○ |
| C-06 | dataurlローダーでBase64エンコード | E-03 | ○ |
| C-07 | CSSファイルのバンドル処理 | E-02 | ○ |
| C-08 | all_loadersでローダー情報管理 | E-01 | ○ |
| C-09 | isJavaScriptLike()ヘルパー | E-01 | ○ |
| C-10 | isCSS()ヘルパー | E-02 | ○ |
| C-11 | 画面No.20(build)が関連画面 | E-03, E-04 | ○ |
| C-12 | bunfig.tomlでカスタムローダー設定 | E-03 | ○ |
| C-13 | ローダータイプ一覧（js, jsx, ts, tsx, json等） | E-03 | ○ |
| C-14 | Bun.plugin() APIで動的ローダー追加 | **詳細確認要** | △ |

## 4) 不足情報（Unknown / Missing）
- Bun.plugin() APIの動的ローダー追加実装詳細
  - 候補：`src/bun.js/api/` 配下

## 5) リスクフラグ（レビュー観点）
- 0: Bun.plugin() APIは別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Loader enumの定義を確認
- [ ] 各ローダータイプの処理フローを確認
- [ ] isJavaScriptLike()、isCSS()の実装を確認
- [ ] ファイルローダーのURL生成ロジックを確認
