---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：4-ホットリロード.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **デバウンス間隔100ms**：実装コードで確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/watcher.zig` - ウォッチャーメイン実装
- E-02: `src/watcher/INotifyWatcher.zig` - Linux inotify実装
- E-03: `src/watcher/KEventWatcher.zig` - macOS kqueue実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイル変更時に自動リロード（watchモード） | E-04 (機能一覧.csv No.4) | ○ |
| C-02 | --watch、--hotオプション | E-04 (機能一覧.csv No.4備考) | ○ |
| C-03 | max_count=128で同時監視数上限 | E-01 (watcher.zig 37行目) | ○ |
| C-04 | requires_file_descriptorsでプラットフォーム差異 | E-01 (watcher.zig 38-41行目) | ○ |
| C-05 | init()でウォッチャー初期化 | E-01 (watcher.zig 65-101行目) | ○ |
| C-06 | start()でスレッド起動 | E-01 (watcher.zig 110-113行目) | ○ |
| C-07 | Platform型でプラットフォーム切り替え | E-01 (watcher.zig 143-148行目) | ○ |
| C-08 | macOS:kqueue実装 | E-03 (KEventWatcher.zig) | ○ |
| C-09 | Linux:inotify実装 | E-02 (INotifyWatcher.zig) | ○ |
| C-10 | onFileUpdate/onErrorコールバック | E-01 (watcher.zig 32-33行目) | ○ |
| C-11 | WatchEvent構造体でイベント情報管理 | E-01 (watcher.zig 150行目以降) | ○ |
| C-12 | 画面No.1「run」の補助機能 | E-05 (画面機能マッピング.csv) | ○ |
| C-13 | deinit()でリソース解放 | E-01 (watcher.zig 115-132行目) | ○ |
| C-14 | デバウンス間隔100ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- デバウンス間隔の具体的な実装箇所の確認が必要
  - 候補：watcher.zig内のタイマー処理 / イベントループ実装

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：機能概要、処理フロー、コードリーディングガイドは十分な根拠あり
- 1（中リスク）：デバウンス間隔の具体的数値は検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] デバウンス間隔の実装が正しいか確認
- [ ] プラットフォーム固有実装の切り替えが正しいか確認
- [ ] エラーハンドリングが網羅されているか確認
