---
generated_at: 2026-01-27 17:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：41-npmレジストリ機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **リトライ仕様**：具体的なリトライ回数・バックオフアルゴリズムの実装確認が必要
  2. **キャッシュ有効期限300秒**：実装での定数値の確認が必要
  3. **並列リクエスト最大16**：設定可能値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/install/npm.zig` - Registry.Scope構造体（196-378行目）
- E-02: `src/install/npm.zig` - whoami関数（8-146行目）
- E-03: `src/install/npm.zig` - getPackageMetadata関数（393-464行目）
- E-04: `src/install/npm.zig` - default_url定数（197行目）
- E-05: `src/install/install.zig` - Features構造体（135-192行目）
- E-06: `src/install/PackageManager.zig` - Subcommandの定義（139-203行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.41の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npmレジストリのデフォルトURLはhttps://registry.npmjs.org/ | E-04 | ○ |
| C-02 | Registry.Scope構造体が認証情報を保持する | E-01 | ○ |
| C-03 | whoami関数で認証状態を確認する | E-02 | ○ |
| C-04 | getPackageMetadataがマニフェスト取得の主要関数 | E-03 | ○ |
| C-05 | ステータスコード304でキャッシュを使用 | E-03（409行目） | ○ |
| C-06 | ステータスコード404でnot_foundを返す | E-03（407行目） | ○ |
| C-07 | ステータスコード400でBadRequest | E-03（405行目） | ○ |
| C-08 | ステータスコード429でTooManyRequests | E-03（406行目） | ○ |
| C-09 | Bearer Token形式の認証をサポート | E-01（274-276行目） | ○ |
| C-10 | ユーザー名/パスワード認証をサポート | E-01（340-348行目） | ○ |
| C-11 | スコープ付きパッケージ（@org/pkg）をサポート | E-01（222-230行目） | ○ |
| C-12 | ETag/Last-Modified による条件付きリクエスト | E-03（415-431行目） | ○ |
| C-13 | キャッシュ有効期限は300秒 | E-03（448行目） | ○ |
| C-14 | Features構造体でdependencies、dev_dependencies等を制御 | E-05 | ○ |
| C-15 | 画面No.6 installがnpmレジストリを使用 | E-07 | ○ |
| C-16 | 画面No.7 addがnpmレジストリを使用 | E-07 | ○ |
| C-17 | 画面No.9 updateがnpmレジストリを使用 | E-07 | ○ |
| C-18 | 環境変数でトークンを設定可能 | E-01（353行目） | ○ |
| C-19 | gzip圧縮レスポンスの自動展開 | E-02（33行目 accept-encoding） | ○ |
| C-20 | User-Agent ヘッダーを送信 | E-02（43-52行目） | ○ |
| C-21 | npm-command ヘッダーを送信 | E-02（41行目） | ○ |
| C-22 | OTPレスポンスの処理 | E-01（183-188行目 responseError） | ○ |
| C-23 | HTTPSへの自動アップグレード | **根拠なし** | △ |
| C-24 | リトライは最大3回 | **根拠なし** | △ |
| C-25 | 並列リクエストは最大16 | **根拠なし** | △ |
| C-26 | CI環境の検出 | E-02（23行目 detectCIName） | ○ |
| C-27 | Subcommandにpublish、audit等が含まれる | E-06 | ○ |
| C-28 | PackageManifest.parseでJSONをパース | E-03（440-461行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- **HTTPSアップグレードの実装箇所**
  - 候補：NetworkTask.zig / http.zig / URL処理部分
- **リトライ仕様の詳細**
  - 候補：NetworkTask.zig / PackageManager.zig のエラー処理部分
- **並列リクエスト数の設定**
  - 候補：PackageManager.zig の thread_pool 設定 / bunfig.toml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の実装は確認済み
- 1: 中リスク - リトライ・並列処理のパラメータは要確認
- 0: 低リスク - 認証処理は詳細に実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] リトライ仕様（回数、バックオフ）の実装を確認
- [ ] HTTPSアップグレードの実装有無を確認
- [ ] 並列リクエスト数の設定可能範囲を確認
- [ ] プライベートレジストリでの動作確認手順を追加検討
