---
generated_at: 2026-01-27 17:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 19
  claims_without_evidence: 3
confidence_derived: 0.86
---

# 根拠レポート：42-グローバルキャッシュ機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：19 / 22、根拠なし：3
- 優先レビュー（高）
  1. **macOS APFSクローン活用**：実装有無の確認が必要
  2. **キャッシュパスの計算式**：詳細な実装確認が必要
  3. **キャッシュヒット時10ms/パッケージ**：ベンチマーク確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/install/PackageManager.zig` - cache_directory_フィールド（1行目）
- E-02: `src/install/PackageManager.zig` - global_link_dir, global_dirフィールド（94-96行目）
- E-03: `src/install/install.zig` - Store構造体参照（257行目）
- E-04: `src/install/extract_tarball.zig` - ExtractTarball構造体
- E-05: `src/install/PackageInstall.zig` - PackageInstall構造体
- E-06: `src/install/bin.zig` - Bin構造体
- E-07: `src/install/integrity.zig` - integrity検証
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.42の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | キャッシュディレクトリは~/.bun/install/cache | E-01 | ○ |
| C-02 | cache_directory_フィールドでキャッシュパスを保持 | E-01 | ○ |
| C-03 | global_link_dirでグローバルリンクを管理 | E-02 | ○ |
| C-04 | Store構造体でキャッシュストアを管理 | E-03 | ○ |
| C-05 | ExtractTarballでtarball展開を実行 | E-04 | ○ |
| C-06 | PackageInstallでインストール処理を実行 | E-05 | ○ |
| C-07 | Bin構造体でバイナリリンクを処理 | E-06 | ○ |
| C-08 | integrity.zigで整合性検証を実行 | E-07 | ○ |
| C-09 | ハードリンクを優先使用 | E-05（copyfile操作） | ○ |
| C-10 | 画面No.6 installがキャッシュを使用 | E-08 | ○ |
| C-11 | 画面No.12 linkがグローバルキャッシュに登録 | E-08 | ○ |
| C-12 | 画面No.17 pmでキャッシュ管理 | E-08 | ○ |
| C-13 | SHA512でintegrityを検証 | E-07 | ○ |
| C-14 | 一時ディレクトリ展開後にリネーム | E-04 | ○ |
| C-15 | パッチ適用版は別キャッシュに保存 | E-03（patch関連） | ○ |
| C-16 | ハードリンク失敗時コピーにフォールバック | E-05 | ○ |
| C-17 | ENOSPC、EACCES等のエラーハンドリング | E-05 | ○ |
| C-18 | マルチスレッド並列展開 | E-01（thread_pool） | ○ |
| C-19 | シンボリックリンク攻撃対策 | E-04 | ○ |
| C-20 | macOS APFSクローン活用 | **根拠なし** | △ |
| C-21 | キャッシュヒット時10ms/パッケージ以下 | **根拠なし** | △ |
| C-22 | Windowsでジャンクション使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **macOS APFSクローンの実装箇所**
  - 候補：PackageInstall.zig / FileCopier.zig / bun.zig
- **パフォーマンス仕様の根拠**
  - 候補：ベンチマーク結果 / 設計ドキュメント
- **Windows固有のジャンクション処理**
  - 候補：PackageInstall.zig のWindows分岐 / bun.zig

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キャッシュ基本機能は確認済み
- 1: 中リスク - OS固有機能（APFS、ジャンクション）の実装確認が必要
- 0: 低リスク - ハードリンク/コピーのフォールバックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] macOS APFSクローン活用の実装有無を確認
- [ ] Windows環境でのジャンクション処理を確認
- [ ] キャッシュパスの計算ロジックを実装と照合
- [ ] パフォーマンス要件の根拠（ベンチマーク）を確認
