---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：45-パッチ管理機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **patch-package互換形式**：詳細な互換性確認が必要
  2. **パッチ削除コマンド**：実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/install/patch_install.zig` - パッチ適用ロジック
- E-02: `src/install/PackageManager.zig` - Subcommand.patch定義（147行目）
- E-03: `src/install/PackageManager.zig` - Subcommand.@"patch-commit"（148行目）
- E-04: `src/install/PackageManager.zig` - patch_apply_batch（61行目）
- E-05: `src/install/PackageManager.zig` - patch_calc_hash_batch（62行目）
- E-06: `src/install/PackageManager.zig` - patch_task_fifo（63行目）
- E-07: `src/install/PackageManager.zig` - patch_task_queue（64行目）
- E-08: `src/install/PackageManager.zig` - pending_pre_calc_hashes（69行目）
- E-09: `src/install/PackageManager.zig` - patched_dependencies_to_remove（132行目）
- E-10: `src/install/pnpm.zig` - patchedDependencies処理（196-222行目）
- E-11: `src/install/pnpm.zig` - patch_hash_idx（22-23行目）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.45の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Subcommand.patchでパッチコマンドを定義 | E-02 | ○ |
| C-02 | Subcommand.@"patch-commit"でコミットコマンドを定義 | E-03 | ○ |
| C-03 | patch_apply_batchでパッチ適用をバッチ処理 | E-04 | ○ |
| C-04 | patch_calc_hash_batchでハッシュ計算をバッチ処理 | E-05 | ○ |
| C-05 | patch_task_fifoでパッチタスクをFIFO管理 | E-06 | ○ |
| C-06 | patch_task_queueでパッチタスクキュー管理 | E-07 | ○ |
| C-07 | pending_pre_calc_hashesでハッシュ計算を追跡 | E-08 | ○ |
| C-08 | patched_dependencies_to_removeで削除対象管理 | E-09 | ○ |
| C-09 | pnpm形式のpatchedDependenciesをサポート | E-10 | ○ |
| C-10 | patch_hash_idxでパッチハッシュをパース | E-11 | ○ |
| C-11 | 画面No.6 installでパッチ適用 | E-12 | ○ |
| C-12 | found_patchesでパッチ情報を管理 | E-10（136-137行目） | ○ |
| C-13 | パッチパスはpatches/<pkg>@<version>.patch | E-10（197-218行目） | ○ |
| C-14 | パッチハッシュはstring_bufに保存 | E-10（218行目） | ○ |
| C-15 | 毎回パッチハッシュを再計算 | E-08（コメント） | ○ |
| C-16 | Features.patched_dependenciesフラグ | E-10関連 | ○ |
| C-17 | PatchTaskで非同期パッチ適用 | E-07 | ○ |
| C-18 | PatchTaskQueueは無制限キュー | E-07（288行目） | ○ |
| C-19 | patch-package形式互換 | **根拠なし** | △ |
| C-20 | bun pm patch-removeコマンド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **patch-package形式との互換性詳細**
  - 候補：patch_install.zig内の形式検証ロジック
- **パッチ削除コマンドの実装**
  - 候補：cli/ 配下のコマンド定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なパッチ機能は詳細に確認済み
- 1: 中リスク - patch-package互換性の詳細確認が必要
- 0: 低リスク - pnpm互換は明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] patch-package形式との互換性テストを確認
- [ ] パッチ削除コマンドの存在と動作を確認
- [ ] パッチ適用失敗時のロールバック動作を確認
- [ ] パッチコンフリクト時のエラーメッセージを確認
