---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：48-Jest互換テスト機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **test.retry()の実装状況**：実装有無の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/test/jest.zig` - TestRunner構造体（64-172行目）
- E-02: `src/bun.js/test/jest.zig` - Summary構造体（116-128行目）
- E-03: `src/bun.js/test/jest.zig` - Jest.createTestModule関数（181-211行目）
- E-04: `src/bun.js/test/jest.zig` - createMockObjects関数（213-252行目）
- E-05: `src/bun.js/test/jest.zig` - jsSetDefaultTimeout関数（289-302行目）
- E-06: `src/bun.js/test/bun_test.zig` - BunTest構造体（205-277行目）
- E-07: `src/bun.js/test/bun_test.zig` - BunTestRoot構造体（125-203行目）
- E-08: `src/bun.js/test/bun_test.zig` - genericHook関数（40-118行目）
- E-09: `src/bun.js/test/expect.zig` - Expect構造体（18-32行目）
- E-10: `src/bun.js/test/expect.zig` - Flags定義（54-101行目）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.48の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TestRunner構造体でテスト実行を管理 | E-01 | ○ |
| C-02 | Summary構造体でpass/fail/skip等をカウント | E-02 | ○ |
| C-03 | createTestModuleでtest/it/describe等を登録 | E-03 | ○ |
| C-04 | test_scope_functionsでtest関数を生成 | E-03（184行目） | ○ |
| C-05 | describe_scope_functionsでdescribe関数を生成 | E-03（192行目） | ○ |
| C-06 | xtest、xdescribeでスキップ関数を生成 | E-03（188-196行目） | ○ |
| C-07 | beforeEach、beforeAll、afterAll、afterEachを登録 | E-03（198-202行目） | ○ |
| C-08 | onTestFinishedを登録 | E-03（202行目） | ○ |
| C-09 | setDefaultTimeoutを登録 | E-03（203行目） | ○ |
| C-10 | expect を Expect.js.getConstructor で登録 | E-03（204行目） | ○ |
| C-11 | createMockObjectsでjest/viオブジェクトを構築 | E-04 | ○ |
| C-12 | jest.fn()をmockFnで実装 | E-04（217行目） | ○ |
| C-13 | jest.spyOn()をspyOnで実装 | E-04（218行目） | ○ |
| C-14 | jest.restoreAllMocks()を実装 | E-04（219行目） | ○ |
| C-15 | jest.mock()（モジュールモック）を実装 | E-04（221行目） | ○ |
| C-16 | viオブジェクトを構築（Vitest互換） | E-04（242-249行目） | ○ |
| C-17 | jsSetDefaultTimeoutでタイムアウトを設定 | E-05 | ○ |
| C-18 | BunTest構造体でテスト状態を管理 | E-06 | ○ |
| C-19 | BunTestRoot構造体でルートを管理 | E-07 | ○ |
| C-20 | genericHookでフック処理を実装 | E-08 | ○ |
| C-21 | Expect構造体でアサーションを管理 | E-09 | ○ |
| C-22 | Flags.notでnotフラグを管理 | E-10（63行目） | ○ |
| C-23 | Flags.promiseでresolves/rejectsを管理 | E-10（57-61行目） | ○ |
| C-24 | 画面No.4 testでテスト実行 | E-11 | ○ |
| C-25 | FakeTimers.putTimersFnsでタイマーモックを登録 | E-04（251行目） | ○ |
| C-26 | test.retry()の実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **test.retry()の実装箇所**
  - 候補：bun_test.zig / jest.zig内のretry関連処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なJest APIは確認済み
- 0: 低リスク - モック機能は詳細に実装されている
- 0: 低リスク - Vitest互換も提供されている

## 6) レビュアーチェックリスト（最小）
- [ ] test.retry()の実装有無を確認
- [ ] Jest固有のマッチャー（toHaveBeenCalled等）の互換性を確認
- [ ] --watchモードの動作を確認
- [ ] JUnit XML出力の互換性を確認
