---
generated_at: 2026-01-27 17:50:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-スナップショットテスト機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。追加の確認は不要。

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/test/snapshot.zig` - file_header定義（2行目）
- E-02: `src/bun.js/test/snapshot.zig` - snapshots_dir_name定義（3行目）
- E-03: `src/bun.js/test/snapshot.zig` - Snapshots構造体（6-19行目）
- E-04: `src/bun.js/test/snapshot.zig` - InlineSnapshotToWrite構造体（21-37行目）
- E-05: `src/bun.js/test/snapshot.zig` - addCount関数（44-55行目）
- E-06: `src/bun.js/test/snapshot.zig` - getOrPut関数（56-114行目）
- E-07: `src/bun.js/test/snapshot.zig` - parseFile関数（116-188行目）
- E-08: `src/bun.js/test/snapshot.zig` - writeSnapshotFile関数（190-211行目）
- E-09: `src/bun.js/test/snapshot.zig` - addInlineSnapshotToWrite関数（213-219行目）
- E-10: `src/bun.js/test/snapshot.zig` - writeInlineSnapshots関数（222-482行目）
- E-11: `src/bun.js/test/snapshot.zig` - CI環境チェック（89-98行目）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.49の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | file_headerで"// Bun Snapshot v1"を定義 | E-01 | ○ |
| C-02 | snapshots_dir_nameで"__snapshots__"を定義 | E-02 | ○ |
| C-03 | Snapshots.totalで総スナップショット数を管理 | E-03（8行目） | ○ |
| C-04 | Snapshots.addedで新規追加数を管理 | E-03（9行目） | ○ |
| C-05 | Snapshots.passedで一致数を管理 | E-03（10行目） | ○ |
| C-06 | Snapshots.failedで不一致数を管理 | E-03（11行目） | ○ |
| C-07 | Snapshots.update_snapshotsで更新モードを管理 | E-03（7行目） | ○ |
| C-08 | ValuesHashMapでスナップショット値を保持 | E-03（4行目） | ○ |
| C-09 | InlineSnapshotToWrite.lineで行番号を保持 | E-04（22行目） | ○ |
| C-10 | InlineSnapshotToWrite.colで列番号を保持 | E-04（23行目） | ○ |
| C-11 | InlineSnapshotToWrite.valueで値を保持 | E-04（24行目） | ○ |
| C-12 | addCount関数でカウンター管理 | E-05 | ○ |
| C-13 | getOrPut関数でスナップショット取得・保存 | E-06 | ○ |
| C-14 | CI環境ではupdate_snapshotsがない場合エラー | E-11（89-98行目） | ○ |
| C-15 | SnapshotCreationNotAllowedInCIエラーを返す | E-11（97行目） | ○ |
| C-16 | last_error_snapshot_nameでエラー時の名前を保持 | E-11（92-96行目） | ○ |
| C-17 | parseFile関数で既存.snapをパース | E-07 | ○ |
| C-18 | JSパーサーを使用してパース | E-07（142-148行目） | ○ |
| C-19 | exports[`name`] = `value`形式を抽出 | E-07（163-180行目） | ○ |
| C-20 | writeSnapshotFile関数でファイル書き出し | E-08 | ○ |
| C-21 | addInlineSnapshotToWrite関数でインライン追加 | E-09 | ○ |
| C-22 | writeInlineSnapshots関数でソース更新 | E-10 | ○ |
| C-23 | 行・列番号でソート | E-10（241行目） | ○ |
| C-24 | TSXパーサーで更新位置を特定 | E-10（324-325行目） | ○ |
| C-25 | バッククォートでエスケープ | E-10（450-452行目） | ○ |
| C-26 | getSnapshotFile関数でファイル取得 | E-06（484行目以降） | ○ |
| C-27 | 画面No.4 testでスナップショットテスト | E-12 | ○ |
| C-28 | DiffFormatterでdiff表示 | E-10（276-281行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スナップショット機能は詳細に実装されている
- 0: 低リスク - CI環境保護も実装されている
- 0: 低リスク - インラインスナップショット更新も実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] 大きなスナップショットのパフォーマンスを確認
- [ ] カスタムシリアライザーのサポート状況を確認
- [ ] Jest --ci オプションとの互換性を確認
