---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：50-モック機能設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **mock.instancesの実装**：C++実装部分の確認が必要
  2. **mock.contextsの実装**：C++実装部分の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/test/jest.zig` - createMockObjects関数（213-252行目）
- E-02: `src/bun.js/test/jest.zig` - setSystemTime登録（214行目）
- E-03: `src/bun.js/test/jest.zig` - mockFn登録（217行目）
- E-04: `src/bun.js/test/jest.zig` - spyOn登録（218行目）
- E-05: `src/bun.js/test/jest.zig` - restoreAllMocks登録（219行目）
- E-06: `src/bun.js/test/jest.zig` - clearAllMocks登録（220行目）
- E-07: `src/bun.js/test/jest.zig` - mockModuleFn登録（221行目）
- E-08: `src/bun.js/test/jest.zig` - jestオブジェクト構築（227-238行目）
- E-09: `src/bun.js/test/jest.zig` - viオブジェクト構築（242-249行目）
- E-10: `src/bun.js/test/jest.zig` - FakeTimers.putTimersFns（251行目）
- E-11: `src/bun.js/test/jest.zig` - extern fn定義（254-261行目）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.50の画面関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createMockObjectsでモック関数を登録 | E-01 | ○ |
| C-02 | JSMock__jsSetSystemTimeでシステム時刻モック | E-02, E-11 | ○ |
| C-03 | JSMock__jsMockFnでjest.fn()を実装 | E-03, E-11 | ○ |
| C-04 | JSMock__jsSpyOnでjest.spyOn()を実装 | E-04, E-11 | ○ |
| C-05 | JSMock__jsRestoreAllMocksですべてリストア | E-05, E-11 | ○ |
| C-06 | JSMock__jsClearAllMocksですべてクリア | E-06, E-11 | ○ |
| C-07 | JSMock__jsModuleMockでjest.mock()を実装 | E-07, E-11 | ○ |
| C-08 | jestオブジェクトにfn, mock, spyOn等を設定 | E-08 | ○ |
| C-09 | jest.restoreAllMocksを提供 | E-08（231行目） | ○ |
| C-10 | jest.clearAllMocksを提供 | E-08（232行目） | ○ |
| C-11 | jest.resetAllMocksをclearAllMocksと同義で提供 | E-08（233行目） | ○ |
| C-12 | jest.setSystemTimeを提供 | E-08（234行目） | ○ |
| C-13 | jest.now()を提供 | E-08（235行目） | ○ |
| C-14 | jest.setTimeout()を提供 | E-08（236行目） | ○ |
| C-15 | viオブジェクトを構築（Vitest互換） | E-09 | ○ |
| C-16 | vi.fn()を提供 | E-09（243行目） | ○ |
| C-17 | vi.mock()を提供 | E-09（244行目） | ○ |
| C-18 | vi.spyOn()を提供 | E-09（245行目） | ○ |
| C-19 | vi.restoreAllMocks()を提供 | E-09（246行目） | ○ |
| C-20 | vi.resetAllMocks()を提供 | E-09（247行目） | ○ |
| C-21 | vi.clearAllMocks()を提供 | E-09（248行目） | ○ |
| C-22 | FakeTimers.putTimersFnsでタイマーモック登録 | E-10 | ○ |
| C-23 | mock.instancesプロパティ | **根拠なし（C++実装）** | △ |
| C-24 | mock.contextsプロパティ | **根拠なし（C++実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- **mock.instances、mock.contextsの実装詳細**
  - 候補：bindings.cpp / MockFunction.cpp等のC++実装
- **mockImplementation、mockReturnValueの実装**
  - 候補：bindings.cpp / MockFunction関連のC++実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なモックAPIの登録は確認済み
- 1: 中リスク - C++実装部分の詳細確認が必要
- 0: 低リスク - Vitest互換も提供されている

## 6) レビュアーチェックリスト（最小）
- [ ] mock.instances、mock.contextsのC++実装を確認
- [ ] mockImplementation、mockReturnValueの実装を確認
- [ ] Jest モックAPIとの完全な互換性を確認
- [ ] FakeTimersの詳細機能（advanceTimersByTime等）を確認
