---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-コードカバレッジ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的数値の根拠不足
  2. **デフォルト閾値90%**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/sourcemap/CodeCoverage.zig` - カバレッジ計算・レポート生成の実装
- E-02: `src/cli/test_command.zig` - テストコマンドとカバレッジオプション処理
- E-03: `src/cli/Arguments.zig` - コマンドライン引数定義
- E-04: `src/bunfig.zig` - 設定ファイル定義
- E-05: `src/sourcemap/sourcemap.zig` - ソースマップ関連処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JSCエンジンの基本ブロックカバレッジを使用 | E-01 (274-286行目: CodeCoverage__withBlocksAndFunctions) | ○ |
| C-02 | 行単位・関数単位・ステートメント単位でカバレッジ収集 | E-01 (17-26行目: Report構造体) | ○ |
| C-03 | --coverageオプションでカバレッジを有効化 | E-02, E-03 | ○ |
| C-04 | テキスト形式でのレポート出力対応 | E-01 (61-208行目: Text.writeFormat) | ○ |
| C-05 | LCOV形式でのレポート出力対応 | E-01 (210-262行目: Lcov.writeFormat) | ○ |
| C-06 | ソースマップによる元ファイル行番号マッピング | E-01 (530-637行目: ソースマップ処理分岐) | ○ |
| C-07 | ByteRangeMappingでバイトオフセットと行番号をマッピング | E-01 (358-406行目) | ○ |
| C-08 | Bitsetで実行可能行と実行行を管理 | E-01 (17-26行目, 727行目: Bitset定義) | ○ |
| C-09 | 行カバレッジ率の計算式 | E-01 (28-41行目: linesCoverageFraction) | ○ |
| C-10 | 関数カバレッジ率の計算式 | E-01 (53-59行目: functionCoverageFraction) | ○ |
| C-11 | 未実行関数内の行は実行可能として計上 | E-01 (509-529行目) | ○ |
| C-12 | LCOVフォーマットのDA,LF,LH出力 | E-01 (248-260行目) | ○ |
| C-13 | 各行の実行回数（line_hits）を記録 | E-01 (21行目, 421-422行目) | ○ |
| C-14 | JSCは分岐カバレッジを直接サポートしていない | E-01 (244行目コメント) | ○ |
| C-15 | JSCは関数名の取得を未サポート | E-01 (229行目コメント) | ○ |
| C-16 | Fraction構造体でデフォルト閾値を定義 | E-01 (709-717行目: Fraction struct) | ○ |
| C-17 | パフォーマンス要件：10-20%オーバーヘッド | **根拠なし** | △ |
| C-18 | パフォーマンス要件：1000ファイル以上で10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はソースコードからは確認できない
  - 候補：ベンチマークテスト / ドキュメント / 開発者インタビュー
- --coverage-dirオプションの詳細な動作確認
  - 候補：test_command.zig追加調査 / bunfig.zig設定項目

## 5) リスクフラグ（レビュー観点）
- 0: CodeCoverage.zigの実装は安定しており、主要機能の根拠が確認できる
- 1: パフォーマンス要件は公式ドキュメントまたはベンチマーク結果での確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] CodeCoverage.zigのReport構造体フィールドが設計書と一致しているか
- [ ] LCOV出力形式が標準フォーマットに準拠しているか
- [ ] パフォーマンス要件の数値が妥当か（実測が必要）
- [ ] --coverage-reporter オプションの実装有無の確認
