---
generated_at: 2026-01-27 17:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-Watchモード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件（100ms以内）**：具体的な数値の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/hot_reloader.zig` - ウォッチモードの中核実装
- E-02: `src/cli/test_command.zig` - テストコマンド実装
- E-03: `src/bun.js/VirtualMachine.zig` - VMの状態管理
- E-04: `src/cli/Arguments.zig` - CLI引数定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HotReloaderとWatchReloaderの2種類が存在 | E-01 (64-65行目) | ○ |
| C-02 | WatchReloaderはreload_immediately=trueで即座再起動 | E-01 (65行目, 208-216行目) | ○ |
| C-03 | --watchオプションでウォッチモード有効化 | E-02, E-04 | ○ |
| C-04 | enableHotModuleReloadingでウォッチャー初期化 | E-01 (238-297行目) | ○ |
| C-05 | onFileUpdateでファイル変更イベント処理 | E-01 (331-400行目) | ○ |
| C-06 | bun.reloadProcessでプロセス再起動 | E-01 (214行目) | ○ |
| C-07 | Taskでバッチ処理（最大8件） | E-01 (159-186行目) | ○ |
| C-08 | macOSのvimアトミック保存対応 | E-01 (129-139行目, 380-396行目) | ○ |
| C-09 | clear_screenフラグで画面クリア制御 | E-01 (119行目, 294行目) | ○ |
| C-10 | 環境変数でクリア無効化可能 | E-01 (294行目: hasSetNoClearTerminalOnReload) | ○ |
| C-11 | ImportWatcherはnone/hot/watchの3状態 | E-01 (1-4行目) | ○ |
| C-12 | Watcher.getHashでファイルパスのハッシュ計算 | E-01 (144行目) | ○ |
| C-13 | test_command.zigでhot_reloadに応じたリローダー選択 | E-02 (1535-1539行目) | ○ |
| C-14 | runEventLoopForWatchでウォッチモード時のイベントループ | E-02 (1779-1781行目) | ○ |
| C-15 | ファイル変更検出から再実行まで100ms以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の100ms以内という数値はソースコードからは確認できない
  - 候補：ベンチマークテスト / ドキュメント / 開発者インタビュー
- Windows環境でのReadDirectoryChangesW使用の詳細確認
  - 候補：watcher.zig追加調査

## 5) リスクフラグ（レビュー観点）
- 0: hot_reloader.zigの実装は安定しており、主要機能の根拠が確認できる
- 1: パフォーマンス要件は実測確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] HotReloaderとWatchReloaderの違いが設計書と一致しているか
- [ ] macOSのvimアトミック保存対応が正しく記述されているか
- [ ] パフォーマンス要件の数値が妥当か（実測が必要）
- [ ] 画面クリア制御の環境変数名が正しいか
