---
generated_at: 2026-01-27 17:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：55-Bun.serve

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **同時接続数（数万接続）**：パフォーマンス数値の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/server.zig` - HTTPサーバー実装
- E-02: `src/bun.js/api/BunObject.zig` - Bun.serve登録
- E-03: `src/bun.js/api/server/ServerWebSocket.zig` - WebSocket実装
- E-04: `src/bun.js/api/server/ServerConfig.zig` - サーバー設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | uWebSocketsベースの高性能サーバー | E-01 (532行目: uws.NewApp) | ○ |
| C-02 | HTTP/HTTPS両対応 | E-01 (508-528行目: protocol_enum) | ○ |
| C-03 | developmentモードとproductionモードの切り替え | E-01 (511-518行目: development_kind) | ○ |
| C-04 | NewServer関数でサーバー型を生成 | E-01 (508行目) | ○ |
| C-05 | BunObject.zigでBun.serveを登録 | E-02 (33行目) | ○ |
| C-06 | RequestContextでリクエスト処理 | E-01 (530行目) | ○ |
| C-07 | timeout関数でタイムアウト設定 | E-01 (652-678行目) | ○ |
| C-08 | onUpgradeでWebSocketアップグレード | E-01 (746-999行目) | ○ |
| C-09 | publish関数でWebSocketブロードキャスト | E-01 (700-744行目) | ○ |
| C-10 | subscriberCountでトピック購読者数取得 | E-01 (610-628行目) | ○ |
| C-11 | idleTimeoutは0-255の範囲 | E-01 (680-682行目) | ○ |
| C-12 | Unixソケット対応 | E-01 (640-642行目: config.address == .unix) | ○ |
| C-13 | plugins機能による拡張 | E-01 (555行目, 598-608行目) | ○ |
| C-14 | dev_serverとの連携 | E-01 (557行目) | ○ |
| C-15 | memoryCost関数でメモリ使用量計算 | E-01 (645-650行目) | ○ |
| C-16 | on_clienterrorでクライアントエラーハンドリング | E-01 (564行目) | ○ |
| C-17 | inspector_server_idでデバッガー連携 | E-01 (566行目) | ○ |
| C-18 | 同時接続数：数万接続をサポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 同時接続数の具体的な上限値はソースコードからは確認できない
  - 候補：uWebSocketsドキュメント / ベンチマーク測定
- デフォルトポート3000の設定箇所
  - 候補：ServerConfig.zig追加調査

## 5) リスクフラグ（レビュー観点）
- 0: server.zigの実装は安定しており、主要機能の根拠が確認できる
- 1: パフォーマンス数値は実測確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] NewServer関数のジェネリック生成が正しく理解されているか
- [ ] WebSocketアップグレードのフローが正確か
- [ ] TLS設定オプションが網羅されているか
- [ ] パフォーマンス要件の数値が妥当か（実測が必要）
