---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-WebSocket

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **同時接続数（数万接続）**：パフォーマンス数値の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/server/ServerWebSocket.zig` - WebSocketサーバー実装
- E-02: `src/http/websocket.zig` - WebSocketプロトコル定義
- E-03: `src/bun.js/api/server.zig` - upgrade/publish処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Opcode enumでText/Binary/Ping/Pong等を定義 | E-02 (4-25行目) | ○ |
| C-02 | WebsocketHeaderはpacked structでフレームヘッダー表現 | E-02 (27-86行目) | ○ |
| C-03 | ServerWebSocket構造体でサーバーサイドWebSocket管理 | E-01 (1-60行目) | ○ |
| C-04 | Flagsでssl/closed/opened/binary_typeを管理 | E-01 (9-26行目) | ○ |
| C-05 | onOpen関数で接続オープン時処理 | E-01 (63-117行目) | ○ |
| C-06 | onMessage関数でメッセージ受信処理 | E-01 (119-179行目) | ○ |
| C-07 | onDrain関数でバッファドレイン処理 | E-01 (185-211行目) | ○ |
| C-08 | onClose関数で接続クローズ処理 | E-01 (285行目以降) | ○ |
| C-09 | binaryToJSでBuffer/Uint8Array変換 | E-01 (213-230行目) | ○ |
| C-10 | onUpgradeでHTTPからWebSocketへアップグレード | E-03 (746-999行目) | ○ |
| C-11 | publish関数でトピックへブロードキャスト | E-03 (700-744行目) | ○ |
| C-12 | publishWithOptionsでテキスト/バイナリ/圧縮を指定 | E-03 (721-742行目) | ○ |
| C-13 | binaryTypeでBuffer/Uint8Array/ArrayBufferを選択可能 | E-01 (12行目, 213-230行目) | ○ |
| C-14 | corkでメッセージをバッチ処理 | E-01 (94-99行目) | ○ |
| C-15 | AbortSignalによるキャンセル対応 | E-01 (6行目, 296-300行目) | ○ |
| C-16 | 同時接続数：数万接続をサポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 同時接続数の具体的な上限値はソースコードからは確認できない
  - 候補：uWebSocketsドキュメント / ベンチマーク測定
- WebSocketクライアント実装の詳細
  - 候補：websocket_client.zig追加調査

## 5) リスクフラグ（レビュー観点）
- 0: ServerWebSocket.zigの実装は安定しており、主要機能の根拠が確認できる
- 1: パフォーマンス数値は実測確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocketプロトコルのOpcodeが正しく定義されているか
- [ ] イベントハンドラー（onOpen/onMessage/onClose等）が網羅されているか
- [ ] Pub/Sub機能のsubscribe/publish/unsubscribeが正確か
- [ ] binaryTypeの選択肢が正しく記述されているか
