---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：61-bun_sqlite.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **better-sqlite3互換性の詳細**：API互換性の範囲が不明確
  2. **パフォーマンス比較**：「同等以上の性能」の具体的根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/bun/sqlite.ts` - メインモジュール実装
- E-02: `src/js/internal/sql/sqlite.ts` - SQLiteアダプター実装
- E-03: `src/bun.js/bindings/JSSQLStatement.cpp` - C++バインディング（存在確認）
- E-04: 機能一覧.csv - 機能No.61の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Databaseクラスがfilename引数でファイル/インメモリDBを作成 | E-01 (346-425行目) | ○ |
| C-02 | DatabaseOptionsでreadonly, create, readwrite, strict, safeIntegersをサポート | E-01 (379-409行目) | ○ |
| C-03 | Statementクラスがrun, get, all, values, iterateメソッドを持つ | E-01 (130-341行目) | ○ |
| C-04 | パラメータ数0の場合に高速パスを使用 | E-01 (134-143行目) | ○ |
| C-05 | query()メソッドが最大20件までキャッシュ | E-01 (534行目: MAX_QUERY_CACHE_SIZE = 20) | ○ |
| C-06 | transaction()でBEGIN/COMMITを自動管理 | E-01 (584-666行目) | ○ |
| C-07 | ネストトランザクションはSAVEPOINTで実現 | E-01 (623-625行目) | ○ |
| C-08 | deferred, immediate, exclusiveのトランザクションモード | E-01 (631-634行目) | ○ |
| C-09 | Symbol.disposeによるリソース管理 | E-01 (336-340行目, 476-479行目) | ○ |
| C-10 | serialize/deserializeメソッドでDB保存/復元 | E-01 (450-474行目) | ○ |
| C-11 | loadExtension()でSQLite拡張をロード | E-01 (446-448行目) | ○ |
| C-12 | SQLiteErrorクラスがエラーをラップ | E-01 (670-679行目) | ○ |
| C-13 | runの戻り値にchanges, lastInsertRowidを含む | E-01 (18-23行目, 209-213行目) | ○ |
| C-14 | SQLiteアダプターがBun.sqlと連携 | E-02 (288-715行目) | ○ |
| C-15 | SQLiteアダプターが?プレースホルダを使用 | E-02 (459-477行目) | ○ |
| C-16 | parseSQLQuery()でSQLコマンドを解析 | E-02 (59-207行目) | ○ |
| C-17 | SQLiteはSELECT/INSERT/UPDATE/DELETE等をサポート | E-02 (30, 79-143行目) | ○ |
| C-18 | SQLiteは分散トランザクションをサポートしない | E-02 (679-714行目) | ○ |
| C-19 | constantsオブジェクトがSQLite定数を公開 | E-01 (25-95行目) | ○ |
| C-20 | inTransactionプロパティでトランザクション状態確認 | E-01 (438-440行目) | ○ |
| C-21 | clearQueryCache()でキャッシュクリア | E-01 (505-512行目) | ○ |
| C-22 | fileControl()でSQLite fcntlを呼び出し | E-01 (490-498行目) | ○ |
| C-23 | setCustomSQLite()でカスタムSQLiteを設定 | E-01 (482-488行目) | ○ |
| C-24 | better-sqlite3と同等以上の性能 | **根拠なし** | △ |
| C-25 | better-sqlite3互換のAPI | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24について：パフォーマンスベンチマークの具体的な数値・比較データがない
  - 候補：Bunの公式ベンチマーク / better-sqlite3との比較テスト結果
- C-25について：API互換性の詳細範囲が不明
  - 候補：better-sqlite3のAPIドキュメントとの詳細比較

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様は実装コードから明確に確認可能
- 1: 中リスク - パフォーマンス主張の具体的根拠が不足
- 0: 低リスク - エラー処理の実装が確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Databaseコンストラクタのオプション解析ロジックが正確か確認
- [ ] query()のキャッシュ上限（20件）が適切か確認
- [ ] トランザクションのネスト処理（SAVEPOINT）の動作確認
- [ ] better-sqlite3との互換性範囲を明確化する必要があるか検討
- [ ] パフォーマンス主張の根拠を追加するか検討
