---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：62-Bun_sql.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **postgres.js互換性の詳細**：API互換性の範囲が不明確
  2. **パフォーマンス比較**：従来ドライバとの具体的比較データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/internal/sql/postgres.ts` - TypeScriptアダプター実装
- E-02: `src/sql/postgres.zig` - Zigバインディングエントリ
- E-03: `src/sql/postgres/PostgresSQLConnection.zig` - 接続管理実装
- E-04: 機能一覧.csv - 機能No.62の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createConnectionで接続オプション（hostname, port等）を解析 | E-01 (319-356, 473-499行目) | ○ |
| C-02 | PooledPostgresConnectionでコネクションプールを管理 | E-01 (473行目〜) | ○ |
| C-03 | detectCommand()でSQLコマンドを解析 | E-01 (383-451行目) | ○ |
| C-04 | onResolvePostgresQuery/onRejectPostgresQueryでクエリ結果を処理 | E-01 (236-316行目) | ○ |
| C-05 | SQLResultArrayにcommand, countプロパティを設定 | E-01 (254-262行目) | ○ |
| C-06 | TLS接続をサポート | E-01 (338行目), E-03 (36-39, 171-186行目) | ○ |
| C-07 | sslModeでSSLモード選択（disable, prefer, require等） | E-01 (337行目), E-03 (39行目) | ○ |
| C-08 | idleTimeoutでアイドルタイムアウト設定 | E-01 (487行目), E-03 (41-42行目) | ○ |
| C-09 | connectionTimeoutでデフォルト30秒の接続タイムアウト | E-01 (488行目: 30 * 1000) | ○ |
| C-10 | maxLifetimeで接続の最大ライフタイム設定 | E-01 (489行目), E-03 (56-60行目) | ○ |
| C-11 | prepareでプリペアドステートメント使用有無を設定 | E-01 (490行目) | ○ |
| C-12 | pathでUnix Socket接続をサポート | E-01 (491行目) | ○ |
| C-13 | タイムアウト処理（接続/アイドル）を実装 | E-03 (108-134行目) | ○ |
| C-14 | 自動パイプライニングをサポート | E-03 (86-98行目: registerAutoFlusher) | ○ |
| C-15 | プリペアドステートメントをキャッシュ | E-03 (19行目: statements: PreparedStatementsMap) | ○ |
| C-16 | バックエンドパラメータを管理 | E-03 (24行目: backend_parameters) | ○ |
| C-17 | 分散トランザクションは非サポート | E-01（明示的な記載なし、実装なし） | ○ |
| C-18 | PostgreSQLプロトコルを解析 | E-02 (23行目: protocol), 存在確認 | ○ |
| C-19 | 型変換を実装 | E-02 (24行目: types), 存在確認 | ○ |
| C-20 | passwordに関数を渡して遅延評価可能 | E-01 (494-498行目) | ○ |
| C-21 | postgres.js互換API | **部分的根拠** | △ |
| C-22 | 従来ドライバより高速 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-21について：postgres.jsとのAPI互換性の詳細な比較がない
  - 候補：postgres.jsのAPIドキュメントとの詳細比較
- C-22について：パフォーマンスベンチマークの具体的データがない
  - 候補：Bunの公式ベンチマーク / pgやpostgres.jsとの比較テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 接続オプションとタイムアウト設定の実装が確認可能
- 1: 中リスク - パフォーマンス主張の具体的根拠が不足
- 0: 低リスク - TLS設定とセキュリティ機能の実装が確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 接続オプション（hostname, port, tls等）の解析ロジックが正確か確認
- [ ] コネクションプールの動作が適切か確認
- [ ] タイムアウト処理（接続/アイドル/maxLifetime）の動作確認
- [ ] postgres.js互換性の範囲を明確化する必要があるか検討
- [ ] パフォーマンス主張の根拠を追加するか検討
