---
generated_at: 2026-01-27 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：65-bun_ffi.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **JIT保護の詳細**：ARM Mac固有の動作詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/bun/ffi.ts` - TypeScript FFI API実装
- E-02: `src/bun.js/api/ffi.zig` - Zig FFI実装
- E-03: `src/bun.js/api/ffi.classes.ts` - JSバインディング定義（存在確認）
- E-04: 機能一覧.csv - 機能No.65の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FFIType定義で型名と数値IDをマッピング | E-01 (1-61行目) | ○ |
| C-02 | ffiWrappers配列で各型の変換ロジックを定義 | E-01 (159-338行目) | ○ |
| C-03 | i64/u64はBigIntまたはNumber（安全範囲内）を受け付け | E-01 (185-251行目) | ○ |
| C-04 | uint32_tは負数を0、オーバーフローを-1でクランプ | E-01 (184行目) | ○ |
| C-05 | float/doubleの変換処理 | E-01 (258-274行目) | ○ |
| C-06 | boolは!!valで変換 | E-01 (275-277行目) | ○ |
| C-07 | pointer型はnumber、TypedArray、ArrayBufferを受け付け | E-01 (293-312行目) | ○ |
| C-08 | cstring型はCStringオブジェクトとして返却 | E-01 (357-358行目) | ○ |
| C-09 | buffer型はTypedArrayを要求 | E-01 (314-320行目) | ○ |
| C-10 | function型はJSCallbackまたはnumberを受け付け | E-01 (322-338行目) | ○ |
| C-11 | FFIBuilderで動的関数コードを生成 | E-01 (340-368行目) | ○ |
| C-12 | 引数数に応じたラッパー特殊化（0-8引数） | E-01 (373-399行目) | ○ |
| C-13 | JSCallbackクラスでJS関数をCコールバック化 | E-01 (82-116行目) | ○ |
| C-14 | JSCallback.close()でリソース解放 | E-01 (103-111行目) | ○ |
| C-15 | JSCallback.ptrでCポインタ取得 | E-01 (90行目) | ○ |
| C-16 | CStringクラスで文字列変換 | E-01 (118-152行目) | ○ |
| C-17 | ptr/toBuffer/toArrayBuffer関数 | E-01 (69-72行目) | ○ |
| C-18 | JIT保護の一時的無効化（ARM Mac） | E-02（詳細確認必要） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：JIT保護の一時的無効化の詳細実装（pthread_jit_write_protect_np）の確認
  - 候補：ffi.zig内のdangerouslyRunWithoutJitProtections関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型変換ロジックの実装が明確
- 0: 低リスク - JSCallbackの実装が明確
- 1: 中リスク - セキュリティ関連（JIT保護無効化）の詳細確認

## 6) レビュアーチェックリスト（最小）
- [ ] FFIType定義と各型の変換ロジックの確認
- [ ] BigInt/Number変換の安全範囲の確認
- [ ] JSCallbackのライフサイクル管理の確認
- [ ] JIT保護無効化のセキュリティ影響評価
- [ ] dlopen/dlsymのエラーハンドリング確認
