---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：68-FileSystemRouter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **将来のルーティングスタイル対応**：他スタイル追加計画の有無

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/api/filesystem_router.zig` - FileSystemRouter実装
- E-02: `src/router.zig` - 内部Router実装（存在確認）
- E-03: 機能一覧.csv - 機能No.68の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileSystemRouter構造体でorigin、base_dir、router管理 | E-01 (10-17行目) | ○ |
| C-02 | style: "nextjs"のみ対応 | E-01 (41-47行目) | ○ |
| C-03 | default_extensions: tsx, jsx, ts, mjs, cjs, js | E-01 (1-8行目) | ○ |
| C-04 | dirオプションで検索開始ディレクトリ指定 | E-01 (49-67行目) | ○ |
| C-05 | fileExtensionsで対象拡張子カスタマイズ | E-01 (72-92行目) | ○ |
| C-06 | assetPrefixオプション | E-01 (94-103行目) | ○ |
| C-07 | originオプション | E-01 (136-143行目) | ○ |
| C-08 | Router.initでルーター初期化 | E-01 (123-128行目) | ○ |
| C-09 | loadRoutesでルート読み込み | E-01 (129-134行目) | ○ |
| C-10 | match関数でstring/Request/Response入力対応 | E-01 (265-293行目) | ○ |
| C-11 | URLPath.parseでパス解析 | E-01 (306-308行目) | ○ |
| C-12 | matchPageWithAllocatorでルートマッチング | E-01 (311-318行目) | ○ |
| C-13 | MatchedRoute構造体で結果返却 | E-01 (396-406行目) | ○ |
| C-14 | KindEnum: exact, catch-all, optional-catch-all, dynamic | E-01 (503-521行目) | ○ |
| C-15 | reload関数でキャッシュクリア | E-01 (219-263行目) | ○ |
| C-16 | bustDirCacheで再帰的キャッシュ削除 | E-01 (176-217行目) | ○ |
| C-17 | getRoutes関数でルート一覧取得 | E-01 (345-362行目) | ○ |
| C-18 | 将来的に他ルーティングスタイル追加の可能性 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：将来のルーティングスタイル追加計画
  - 候補：ロードマップ、issue tracker

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コンストラクタのオプション処理が確認可能
- 0: 低リスク - match関数の入力処理が確認可能
- 0: 低リスク - KindEnum判定ロジックが明確
- 1: 中リスク - Router内部実装の詳細（src/router.zig）

## 6) レビュアーチェックリスト（最小）
- [ ] style: "nextjs"制約の妥当性確認
- [ ] default_extensionsの優先順位確認
- [ ] match関数の入力バリデーション確認
- [ ] reload関数のキャッシュクリア範囲確認
- [ ] MatchedRouteの各プロパティ確認
