---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：69-HTMLRewriter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Cloudflare Workers互換性**：API互換性の詳細範囲

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/api/html_rewriter.zig` - HTMLRewriter実装
- E-02: 機能一覧.csv - 機能No.69の定義
- E-03: LOLHTML - 外部ライブラリドキュメント（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLRewriter構造体でbuilder、contextを管理 | E-01 (34-36行目) | ○ |
| C-02 | LOLHTMLContextでselectors、handlers管理 | E-01 (2-33行目) | ○ |
| C-03 | constructor: LOLHTML.HTMLRewriter.Builder.init | E-01 (43-53行目) | ○ |
| C-04 | on_: セレクタパースとElementHandler登録 | E-01 (55-107行目) | ○ |
| C-05 | HTMLSelector.parseでセレクタパース | E-01 (65-66行目) | ○ |
| C-06 | ElementHandler: element, comments, text | E-01 (975-1031行目) | ○ |
| C-07 | onDocument_: DocumentHandler登録 | E-01 (109-157行目) | ○ |
| C-08 | DocumentHandler: doctype, comments, text, end | E-01 (764-863行目) | ○ |
| C-09 | transform_: Response/string/ArrayBuffer入力 | E-01 (175-239行目) | ○ |
| C-10 | Response入力時beginTransform呼び出し | E-01 (176-187行目) | ○ |
| C-11 | string/ArrayBuffer時一時Response作成 | E-01 (199-236行目) | ○ |
| C-12 | BufferOutputSinkで出力バッファ管理 | E-01 (395-643行目) | ○ |
| C-13 | Element: getAttribute, setAttribute等 | E-01 (1743-1799行目) | ○ |
| C-14 | Element: before, after, prepend, append, replace | E-01 (1817-1894行目) | ○ |
| C-15 | Element: remove, removeAndKeepContent | E-01 (1897-1912行目) | ○ |
| C-16 | TextChunk: before, after, replace, remove | E-01 (1147-1189行目) | ○ |
| C-17 | Comment: before, after, replace, remove, setText | E-01 (1401-1467行目) | ○ |
| C-18 | DocType: name, systemId, publicId | E-01 (1248-1285行目) | ○ |
| C-19 | DocEnd: append | E-01 (1344-1354行目) | ○ |
| C-20 | EndTag: before, after, replace, remove, name | E-01 (1548-1616行目) | ○ |
| C-21 | AttributeIterator for属性列挙 | E-01 (1619-1685行目) | ○ |
| C-22 | Cloudflare Workers HTMLRewriter API完全互換 | **詳細確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22について：Cloudflare Workers APIとの互換性範囲
  - 候補：Cloudflare Workersドキュメント比較、テストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - on/onDocumentのハンドラ登録が明確
- 0: 低リスク - transform_の入力処理が明確
- 0: 低リスク - DOM操作APIが網羅的
- 1: 中リスク - LOLHTML内部動作の詳細
- 1: 中リスク - Cloudflare Workers互換性の範囲

## 6) レビュアーチェックリスト（最小）
- [ ] on関数のセレクタパース処理確認
- [ ] ElementHandler/DocumentHandlerのコールバック実行確認
- [ ] transform_のResponse/string/ArrayBuffer処理確認
- [ ] BufferOutputSinkの出力バッファ管理確認
- [ ] DOM操作API（Element, TextChunk, Comment等）の網羅性確認
- [ ] Cloudflare Workers API互換性の範囲明確化
