---
generated_at: 2026-01-27 18:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：7-プラグインシステム.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **onLoadコールバックの実装**：onLoad処理の詳細実装箇所の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/transpiler.zig` - PluginRunner実装
- E-02: `src/bun.js/bindings/JSGlobalObject.zig` - JavaScript側API
- E-03: `src/bun.js/api/BunObject.zig` - Bun.plugin API
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | カスタムローダーやリゾルバをプラグインで拡張可能 | E-04 (機能一覧.csv No.7) | ○ |
| C-02 | Bun.plugin() API | E-04 (機能一覧.csv No.7備考) | ○ |
| C-03 | PluginRunner構造体でプラグイン実行管理 | E-01 (transpiler.zig 58-60行目) | ○ |
| C-04 | extractNamespace()で名前空間抽出 | E-01 (transpiler.zig 62-71行目) | ○ |
| C-05 | couldBePlugin()でプラグイン適用判定 | E-01 (transpiler.zig 73-83行目) | ○ |
| C-06 | onResolve()でモジュール解決フック | E-01 (transpiler.zig 85-185行目) | ○ |
| C-07 | global.runOnResolvePlugins()でJS側呼び出し | E-01 (transpiler.zig 99-104行目) | ○ |
| C-08 | pathとnamespaceを返却 | E-01 (transpiler.zig 105-185行目) | ○ |
| C-09 | 名前空間file/node/bunをサポート | E-01 (transpiler.zig 150-163行目) | ○ |
| C-10 | 画面No.1「run」の補助機能 | E-05 (画面機能マッピング.csv) | ○ |
| C-11 | onResolveJSC()でJSC環境向け処理 | E-01 (transpiler.zig 187-200行目) | ○ |
| C-12 | Windows環境でのドライブレター考慮 | E-01 (transpiler.zig 64-69行目) | ○ |
| C-13 | BunPluginTargetでターゲット指定 | E-01 (transpiler.zig 91行目) | ○ |
| C-14 | onLoadコールバックの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- onLoadコールバックの詳細実装箇所の確認が必要
  - 候補：ModuleLoader.zig / 別のプラグイン関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：機能概要、処理フロー、onResolve処理は十分な根拠あり
- 1（中リスク）：onLoadの詳細実装は追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] onLoadコールバックの実装箇所を確認
- [ ] esbuildプラグインとの互換性範囲を確認
- [ ] プラグイン実行順序の動作を確認
