---
generated_at: 2026-01-27 17:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-Bun.hash

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：定量的な数値根拠なし
  2. **業務上の目的・背景**：推測に基づく記述

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/HashObject.zig` - ハッシュ関数の実装
- E-02: `src/bun.js/api/BunObject.zig` - hashプロパティの登録（74行目、1263-1265行目）
- E-03: `src/bun.js/api.zig` - HashObjectモジュールエクスポート（28行目）
- E-04: `test/integration/bun-types/fixture/hashing.ts` - 型定義テスト
- E-05: `test/regression/issue/09555.test.ts` - ハッシュ機能使用例
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（71行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトアルゴリズムはwyhash | E-01 (3行目, 50行目) | ○ |
| C-02 | サポートする12種類のハッシュアルゴリズム | E-01 (3-47行目, 51-64行目) | ○ |
| C-03 | 入力として文字列、Blob、ArrayBuffer、TypedArrayを受け付ける | E-01 (85-114行目) | ○ |
| C-04 | シード値をオプションで指定可能 | E-01 (125-130行目) | ○ |
| C-05 | 32bit出力はnumber、64bit出力はbigintで返却 | E-01 (141-144行目) | ○ |
| C-06 | CRC32はzlibのハードウェアアクセラレーション使用 | E-01 (5-20行目, 15行目bun.zlib.crc32呼び出し) | ○ |
| C-07 | CRC32は大規模データをチャンク分割処理 | E-01 (8-18行目) | ○ |
| C-08 | BunObjectからhashプロパティとして公開 | E-02 (74行目) | ○ |
| C-09 | getHashObject関数でHashObject.createを呼び出し | E-02 (1263-1265行目) | ○ |
| C-10 | hashWrap関数が各ハッシュ関数のラッパーを生成 | E-01 (73-148行目) | ○ |
| C-11 | シード値がない場合は0を使用 | E-01 (125行目 `var seed: u64 = 0`) | ○ |
| C-12 | TypedArrayは各種類に対応（Int8Array, Uint8Array等） | E-01 (90-103行目) | ○ |
| C-13 | wyhashはBun.hash()で直接呼び出し可能 | E-04 (1行目) | ○ |
| C-14 | Bun.hashはテストでファイル変更検知に使用 | E-05 (8, 38行目) | ○ |
| C-15 | HashObjectはapi.zigでエクスポート | E-03 (28行目) | ○ |
| C-16 | invalidなArrayBufferでTypeErrorを投げる | E-01 (106行目) | ○ |
| C-17 | パフォーマンスが高速（wyhash） | **根拠なし** | △ |
| C-18 | 業務上の目的（キャッシュ無効化等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスに関する定量的なベンチマーク結果
  - 候補：公式ドキュメント / ベンチマークテスト / 外部比較資料
- ユースケースの公式な定義
  - 候補：公式ドキュメント / API仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能の基本動作は全てソースコードで確認済み
- 1: 中リスク - パフォーマンス主張は定量的根拠なし
- 0: 低リスク - エラー処理はコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされる12種類のハッシュアルゴリズムが正しく記載されているか
- [ ] 入力型の対応が漏れなく記載されているか
- [ ] CRC32のチャンク処理ロジックの説明が正確か
- [ ] パフォーマンス要件の記述が適切か（定量値なしで問題ないか）
