---
generated_at: 2026-01-27 17:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：72-Bun.CryptoHasher

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：定量的根拠なし
  2. **セキュリティ推奨事項**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/crypto/CryptoHasher.zig` - メイン実装
- E-02: `src/bun.js/api/crypto/EVP.zig` - EVPラッパー、アルゴリズム定義
- E-03: `src/bun.js/api/crypto.classes.ts` - JSクラス定義
- E-04: `src/bun.js/api/crypto/HMAC.zig` - HMAC実装
- E-05: `test/regression/issue/09555.test.ts` - テストコード
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（72行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CryptoHasherはunion型（hmac/evp/zig） | E-01 (1-8行目) | ○ |
| C-02 | サポートアルゴリズム（BoringSSL実装） | E-02 (22-34行目, 70-100行目) | ○ |
| C-03 | サポートアルゴリズム（Zig実装） | E-01 (484-492行目) | ○ |
| C-04 | 静的ハッシャークラス8種類 | E-01 (868-875行目) | ○ |
| C-05 | JSクラス定義（CryptoHasher） | E-03 (75-112行目) | ○ |
| C-06 | コンストラクタでアルゴリズム名を検証 | E-01 (244-257行目) | ○ |
| C-07 | HMACキー指定でHMACモード | E-01 (267-295行目) | ○ |
| C-08 | ripemd160はHMAC非対応 | E-01 (276-278行目) | ○ |
| C-09 | updateメソッドでデータ追加 | E-01 (313-360行目) | ○ |
| C-10 | digestメソッドでファイナライズ | E-01 (386-407行目) | ○ |
| C-11 | hash静的メソッドでワンショット | E-01 (211-239行目) | ○ |
| C-12 | copyメソッドで状態コピー | E-01 (362-384行目) | ○ |
| C-13 | digestエンコーディング対応 | E-01 (388-406行目) | ○ |
| C-14 | byteLengthプロパティ | E-01 (138-146行目) | ○ |
| C-15 | algorithmプロパティ | E-01 (148-155行目) | ○ |
| C-16 | algorithmsゲッター（一覧取得） | E-01 (157-159行目) | ○ |
| C-17 | digest後のインスタンス再利用不可 | E-01 (448-451行目 hmac=null) | ○ |
| C-18 | Bun.file()は未サポート | E-01 (165-167行目, 183-185行目) | ○ |
| C-19 | BoringSSLエラー処理 | E-01 (170-174行目, 197-200行目) | ○ |
| C-20 | CryptoHasherZigのalgo_map | E-01 (484-492行目) | ○ |
| C-21 | パフォーマンス（BoringSSL最適化） | **根拠なし** | △ |
| C-22 | MD4/MD5セキュリティ非推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスベンチマーク結果
  - 候補：公式ドキュメント / ベンチマークテスト / 外部比較資料
- セキュリティ推奨事項の公式な定義
  - 候補：公式ドキュメント / セキュリティガイドライン

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アルゴリズムサポート一覧はソースコードで確認済み
- 0: 低リスク - API構造（update/digest）はソースコードで確認済み
- 1: 中リスク - セキュリティ推奨事項は一般的知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされるアルゴリズム一覧が正確か
- [ ] HMAC制限（ripemd160）の記載が正確か
- [ ] エラーケース一覧が網羅されているか
- [ ] 静的ハッシャークラスの記載が正確か
- [ ] Zig実装アルゴリズムの記載が正確か
