---
generated_at: 2026-01-27 17:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：73-$シェル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **セキュリティ（自動エスケープ）**：実装詳細の確認が必要
  2. **パフォーマンス要件**：定量的ベンチマークなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/builtins/shell.ts` - JavaScript API実装
- E-02: `src/shell/shell.zig` - シェルモジュールエントリ
- E-03: `src/shell/interpreter.zig` - インタプリタ実装（コメント含む）
- E-04: `src/shell/Builtin.zig` - 組み込みコマンド定義
- E-05: `src/shell/ParsedShellScript.zig` - パース結果構造
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（73行目）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タグ付きテンプレートリテラルで使用 | E-01 (303行目) | ○ |
| C-02 | ShellPromiseを返す | E-01 (106-250行目) | ○ |
| C-03 | ShellOutput構造（stdout, stderr, exitCode） | E-01 (74-104行目) | ○ |
| C-04 | ShellError（非0終了時） | E-01 (16-72行目) | ○ |
| C-05 | cwd設定メソッド | E-01 (149-156行目) | ○ |
| C-06 | env設定メソッド | E-01 (158-166行目) | ○ |
| C-07 | quiet設定メソッド | E-01 (178-186行目) | ○ |
| C-08 | nothrow設定メソッド | E-01 (188-191行目) | ○ |
| C-09 | throws設定メソッド | E-01 (193-196行目) | ○ |
| C-10 | text()メソッド | E-01 (198-201行目) | ○ |
| C-11 | json()メソッド | E-01 (203-206行目) | ○ |
| C-12 | lines()ジェネレータ | E-01 (208-216行目) | ○ |
| C-13 | 状態マシンベースインタプリタ | E-03 (1-59行目コメント) | ○ |
| C-14 | 非同期IOでメインスレッド非ブロック | E-03 (14-15行目コメント) | ○ |
| C-15 | 組み込みコマンド一覧（18種類） | E-04 (38-58行目, 63-82行目) | ○ |
| C-16 | cat, cpはPOSIXで無効 | E-04 (84行目) | ○ |
| C-17 | ShellErr union型 | E-02 (34-119行目) | ○ |
| C-18 | 標準入出力定数定義 | E-02 (26-28行目) | ○ |
| C-19 | ParsedShellScriptでパース結果管理 | E-01 (304行目), E-05 | ○ |
| C-20 | ShellInterpreterで実行 | E-01 (172-175行目) | ○ |
| C-21 | デフォルトでthrows=true | E-01 (109行目, 349行目) | ○ |
| C-22 | Shell()コンストラクタで新インスタンス作成可能 | E-01 (317-341行目) | ○ |
| C-23 | 埋め込み変数の自動エスケープ | **根拠不足** | △ |
| C-24 | 組み込みコマンドの高速実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 変数エスケープの実装詳細
  - 候補：ParsedShellScript.zig / 関連パーサーコード
- パフォーマンスベンチマーク
  - 候補：公式ドキュメント / ベンチマークテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造はソースコードで確認済み
- 0: 低リスク - 組み込みコマンド一覧は正確
- 1: 中リスク - セキュリティ関連の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 組み込みコマンド一覧が正確か
- [ ] ShellPromiseのメソッドチェーンが正確か
- [ ] POSIXで無効なコマンドの記載が正確か
- [ ] 状態マシンアーキテクチャの説明が適切か
- [ ] セキュリティ（エスケープ処理）の説明が適切か
