---
generated_at: 2026-01-27 17:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：74-TCPソケット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：定量的ベンチマークなし
  2. **同時接続数**：上限の記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/bun/socket.zig` - ソケット本体実装
- E-02: `src/bun.js/api/bun/socket/Listener.zig` - リスナー実装
- E-03: `src/bun.js/api/bun/socket/Handlers.zig` - ハンドラ定義
- E-04: `src/bun.js/api/bun/socket/tls_socket_functions.zig` - TLS関数
- E-05: `src/js/node/net.ts` - Node.js互換レイヤー
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（74行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イベントハンドラ9種類（onOpen等） | E-03 (3-11行目, 23-33行目) | ○ |
| C-02 | NewSocket型でTCP/TLSを共通化 | E-01 (41-48行目) | ○ |
| C-03 | uws.SocketHandlerを内部使用 | E-01 (55行目) | ○ |
| C-04 | UnixOrHost unionで接続先を表現 | E-02 (38-76行目) | ○ |
| C-05 | listen関数でサーバー起動 | E-02 (101行目以降) | ○ |
| C-06 | SocketConfig.fromJSでオプション解析 | E-02 (109行目) | ○ |
| C-07 | doConnectで接続処理 | E-01 (111-139行目) | ○ |
| C-08 | TCP/Unix/FDの3種類の接続方法 | E-01 (116-138行目) | ○ |
| C-09 | ALPNプロトコル選択 | E-01 (17-33行目) | ○ |
| C-10 | Handlers.markActive/markInactiveで接続管理 | E-03 (35-97行目) | ○ |
| C-11 | Handlers.resolvePromise/rejectPromise | E-03 (57-78行目) | ○ |
| C-12 | binaryType設定 | E-03 (13行目) | ○ |
| C-13 | Windowsで名前付きパイプ対応 | E-02 (123-150行目) | ○ |
| C-14 | socket_context管理 | E-01 (58行目), E-02 (10行目) | ○ |
| C-15 | protos（ALPN設定）対応 | E-01 (68行目), E-02 (12行目) | ○ |
| C-16 | allowHalfOpen設定 | E-01 (123, 131行目) | ○ |
| C-17 | poll_refでイベントループ参照管理 | E-01 (65行目), E-02 (8行目) | ○ |
| C-18 | RefCountで参照カウント管理 | E-01 (51-53行目) | ○ |
| C-19 | bytes_writtenで送信バイト数追跡 | E-01 (71行目) | ○ |
| C-20 | reload関数でハンドラ更新 | E-02 (78-99行目) | ○ |
| C-21 | 大量同時接続サポート | **根拠なし** | △ |
| C-22 | uWebSocketsベースの高性能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンスベンチマーク
  - 候補：公式ドキュメント / ベンチマークテスト
- 同時接続数の上限
  - 候補：OS設定 / uws設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造はソースコードで確認済み
- 0: 低リスク - イベントハンドラ一覧は正確
- 1: 中リスク - パフォーマンス主張は定量根拠なし

## 6) レビュアーチェックリスト（最小）
- [ ] イベントハンドラ一覧が正確か
- [ ] Socketメソッド一覧が網羅されているか
- [ ] TLS設定オプションが正確か
- [ ] エラーケースが網羅されているか
- [ ] Windows名前付きパイプの説明が正確か
