---
generated_at: 2026-01-27 18:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：75-UDPソケット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **ブロードキャスト/マルチキャスト**：フラグの詳細確認が必要
  2. **パフォーマンス要件**：定量的ベンチマークなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/bun/udp_socket.zig` - UDPソケット実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（75行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UDPSocketConfig構造体でオプション管理 | E-01 (108-229行目) | ○ |
| C-02 | handlers定義（data, drain, error） | E-01 (110-114行目) | ○ |
| C-03 | hostname, port, flags, binary_type設定 | E-01 (121-125行目) | ○ |
| C-04 | connectオプションで接続先指定 | E-01 (116-119行目, 194-218行目) | ○ |
| C-05 | fromJSでJSオプションをパース | E-01 (127-221行目) | ○ |
| C-06 | UDPSocket構造体 | E-01 (231-257行目) | ○ |
| C-07 | uws.udp.Socket.createでソケット作成 | E-01 (293-319行目) | ○ |
| C-08 | socket.connectで接続 | E-01 (321-337行目) | ○ |
| C-09 | Promise.resolvedPromiseValueで返却 | E-01 (340行目) | ○ |
| C-10 | onDataでパケット受信処理 | E-01 (38-106行目) | ○ |
| C-11 | IPv4/IPv6アドレス変換（inet_ntop） | E-01 (61-67行目) | ○ |
| C-12 | IPv6スコープID対応 | E-01 (68-69行目, 81-90行目) | ○ |
| C-13 | onDrainでバッファ空通知 | E-01 (21-36行目) | ○ |
| C-14 | onCloseでソケットクローズ処理 | E-01 (11-19行目) | ○ |
| C-15 | binaryTypeでデータ形式指定 | E-01 (125行目, 173-181行目) | ○ |
| C-16 | poll_refでイベントループ参照管理 | E-01 (243行目, 339行目) | ○ |
| C-17 | SystemErrorでバインドエラー通知 | E-01 (305-315行目) | ○ |
| C-18 | c_aresエラー変換（EAI_ERROR） | E-01 (332-334行目) | ○ |
| C-19 | ブロードキャスト対応 | **根拠不足** | △ |
| C-20 | 低遅延の高性能実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ブロードキャスト/マルチキャストのフラグ詳細
  - 候補：uws実装 / OSソケットAPI仕様
- パフォーマンスベンチマーク
  - 候補：公式ドキュメント / ベンチマークテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造はソースコードで確認済み
- 0: 低リスク - イベントハンドラ一覧は正確
- 1: 中リスク - ブロードキャスト機能の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] イベントハンドラ一覧（data, drain, error）が正確か
- [ ] 入力パラメータ一覧が正確か
- [ ] IPv6スコープID対応の説明が正確か
- [ ] エラーケースが網羅されているか
- [ ] binaryTypeオプションの説明が正確か
