---
generated_at: 2026-01-27 18:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：76-Fetch API

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **HTTP/2対応**：詳細確認が必要
  2. **RequestInitオプション完全性**：全オプションの網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/webcore/fetch.zig` - fetchエントリーポイント
- E-02: `src/bun.js/webcore/fetch/FetchTasklet.zig` - 非同期タスク管理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（76行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数なしでTypeError | E-01 (1行目, 197-199行目) | ○ |
| C-02 | 空URLでエラー | E-01 (2行目) | ○ |
| C-03 | GET/HEAD/OPTIONSにボディ禁止 | E-01 (3行目) | ○ |
| C-04 | プロキシ+Unixソケット禁止 | E-01 (4行目) | ○ |
| C-05 | Bun__fetch_がエントリーポイント | E-01 (159-170行目) | ○ |
| C-06 | fetchImplで実装 | E-01 (181行目) | ○ |
| C-07 | data: URLをローカル処理 | E-01 (63-96行目) | ○ |
| C-08 | dataURLResponseでBlobとResponse作成 | E-01 (70-95行目) | ○ |
| C-09 | FetchTaskletで非同期管理 | E-02 (1-60行目) | ○ |
| C-10 | http.AsyncHTTP使用 | E-02 (6行目) | ○ |
| C-11 | 参照カウント管理（ref/deref） | E-02 (62-86行目) | ○ |
| C-12 | HTTPRequestBody union型 | E-02 (88-100行目) | ○ |
| C-13 | preconnect機能 | E-01 (98-145行目) | ○ |
| C-14 | HTTP/HTTPS/S3のみpreconnect可 | E-01 (128行目) | ○ |
| C-15 | AbortSignalサポート | E-02 (39行目) | ○ |
| C-16 | reject_unauthorizedオプション | E-02 (49行目) | ○ |
| C-17 | check_server_identityオプション | E-02 (48行目) | ○ |
| C-18 | ReadableStreamでボディ送信可能 | E-02 (91行目) | ○ |
| C-19 | body_sizeでサイズ管理 | E-02 (33行目) | ○ |
| C-20 | signal_storeでシグナル管理 | E-02 (41行目) | ○ |
| C-21 | HTTP/2対応 | **根拠不足** | △ |
| C-22 | コネクションプーリング | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- HTTP/2サポートの実装詳細
  - 候補：http/AsyncHTTP.zig / http2関連ファイル
- コネクションプーリングの実装
  - 候補：http/接続管理関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本API構造はソースコードで確認済み
- 0: 低リスク - エラーメッセージ定義は正確
- 1: 中リスク - RequestInitオプションの網羅性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] エラーメッセージ定義が正確か
- [ ] RequestInitオプション一覧が網羅されているか
- [ ] Responseオブジェクトのプロパティ/メソッドが正確か
- [ ] data: URL処理の説明が正確か
- [ ] preconnect機能の説明が正確か
