---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：81-crypto

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠が不明確
  2. **W3C仕様準拠の詳細**：実装の網羅性が未確認
  3. **タイミング攻撃への耐性**：具体的な対策の実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/crypto.zig` - Web Crypto APIのメインエントリーポイント
- E-02: `src/bun.js/api/crypto/CryptoHasher.zig` - ハッシュアルゴリズム実装
- E-03: `src/bun.js/api/crypto/EVP.zig` - EVP暗号化ラッパー
- E-04: `src/bun.js/api/crypto/HMAC.zig` - HMAC実装
- E-05: `src/bun.js/api/crypto/PasswordObject.zig` - パスワードオブジェクト
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BoringSSLを暗号プリミティブ実装に使用 | E-01 (crypto.zig line 2: bun.BoringSSL) | ○ |
| C-02 | MD4/MD5/SHA1/SHA256/SHA384/SHA512をサポート | E-01 (lines 9-16) | ○ |
| C-03 | CryptoHasher構造体がハッシュ計算を担当 | E-01, E-02 | ○ |
| C-04 | createCryptoError関数でエラー変換 | E-01 (line 1-3) | ○ |
| C-05 | HMAC実装が存在する | E-04 | ○ |
| C-06 | EVPラッパーで暗号化/復号を実装 | E-03 | ○ |
| C-07 | パスワードオブジェクト対応 | E-05 | ○ |
| C-08 | 機能カテゴリはAPI | E-06 | ○ |
| C-09 | Web標準準拠 | **根拠なし** | △ |
| C-10 | 非同期処理はPromiseベース | E-01 (一般的なJS API設計) | ○ |
| C-11 | getRandomValuesは同期処理 | ブラウザ標準仕様に準拠 | ○ |
| C-12 | 鍵生成機能が存在 | E-01 (EVP.zig参照) | ○ |
| C-13 | タイミング攻撃への耐性 | **根拠なし** | △ |
| C-14 | 数百MB/秒以上のハッシュ性能 | **根拠なし** | △ |
| C-15 | JavaScriptCoreとの連携 | E-01 (jsc.JSGlobalObject使用) | ○ |
| C-16 | Node.js crypto互換あり（機能No.90） | E-06 | ○ |
| C-17 | SubtleCrypto実装 | E-06 (備考: SubtleCrypto実装) | ○ |
| C-18 | エラーはJSValueとして返却 | E-01 (line 2: ERR_toJS) | ○ |

## 4) 不足情報（Unknown / Missing）
- W3C Web Crypto API仕様との詳細な適合性テスト結果
  - 候補：W3C Web Crypto APIテストスイート / 実装比較表
- パフォーマンスベンチマーク結果
  - 候補：test/js/bun/crypto/内のベンチマーク / CI結果
- セキュリティ監査報告書
  - 候補：SECURITY.md / 外部監査レポート

## 5) リスクフラグ（レビュー観点）
- 1: パフォーマンス数値は推定値であり、実測が必要
- 1: セキュリティ関連機能のため、実装の正確性確認が重要
- 0: 標準API互換性は高いと推測されるが、エッジケースの確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] BoringSSL関数呼び出しが適切に行われているか確認
- [ ] サポートアルゴリズム一覧が最新か確認
- [ ] エラーハンドリングの網羅性を確認
- [ ] パフォーマンス要件の妥当性を実測で確認
