---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：83-Workers

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **構造化クローンの実装詳細**：シリアライズ処理の実装確認が必要
  2. **SharedArrayBuffer対応**：現在の対応状況確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/web_worker.zig` - Web Workersのメイン実装（全655行読込）
- E-02: `src/js/node/worker_threads.ts` - Node.js worker_threads互換
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebWorker構造体が中心的なデータ構造 | E-01 (lines 7-28) | ○ |
| C-02 | Status enumでstart/starting/running/terminated管理 | E-01 (lines 43-48) | ○ |
| C-03 | create関数でWorker生成 | E-01 (lines 188-262) | ○ |
| C-04 | std.Thread.spawnでスレッド生成 | E-01 (lines 71-79) | ○ |
| C-05 | resolveEntryPointSpecifierでパス解決 | E-01 (lines 83-186) | ○ |
| C-06 | jsc.VirtualMachine.initWorkerでVM初期化 | E-01 (line 328) | ○ |
| C-07 | spin関数でイベントループ維持 | E-01 (lines 452-540) | ○ |
| C-08 | exitAndDeinitで終了処理 | E-01 (lines 587-635) | ○ |
| C-09 | dispatchOnlineでonlineイベント発火 | E-01 (line 506) | ○ |
| C-10 | name引数でWorker名設定 | E-01 (lines 246-251) | ○ |
| C-11 | eval_modeでコード文字列評価対応 | E-01 (line 28) | ○ |
| C-12 | argv/execArgv引数対応 | E-01 (lines 37-38, 254-255) | ○ |
| C-13 | 構造化クローンでメッセージシリアライズ | **根拠不足（C++側実装）** | △ |
| C-14 | SharedArrayBufferを除きメモリ非共有 | **根拠不足** | △ |
| C-15 | parent_poll_refでイベントループ参照管理 | E-01 (lines 34, 259, 370) | ○ |
| C-16 | bun.default_thread_stack_size使用 | E-01 (line 72) | ○ |
| C-17 | --no-addonsオプション対応 | E-01 (line 321) | ○ |
| C-18 | worker_threadsモジュール互換 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 構造化クローンの具体的実装（C++側）
  - 候補：`src/bun.js/bindings/`内のWorker関連C++ファイル
- SharedArrayBuffer対応の現状
  - 候補：テストコードまたはissue tracker

## 5) リスクフラグ（レビュー観点）
- 1: Worker間メッセージパッシングのパフォーマンス確認推奨
- 1: 大量Worker生成時のリソース消費確認推奨
- 0: 基本的なWorker機能は安定していると推測

## 6) レビュアーチェックリスト（最小）
- [ ] Worker生成時のメモリ使用量を確認
- [ ] terminate()呼び出し時の適切なリソース解放を確認
- [ ] エラー発生時の親スレッドへの適切な伝播を確認
- [ ] preload機能の動作確認（lines 219-234, 458）
