---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：87-node:fs

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Node.js完全互換性**：一部未実装APIの確認が必要
  2. **ストリームAPI実装**：createReadStream/createWriteStreamの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/node/node_fs.zig` - メイン実装（lines 1-500読込）
- E-02: `src/bun.js/node/node_fs_binding.zig` - JSバインディング
- E-03: `src/bun.js/node/node_fs_constant.zig` - 定数定義
- E-04: `src/bun.js/node/node_fs_watcher.zig` - ファイル監視
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Flavor enumでsync/async定義 | E-01 (line 23) | ○ |
| C-02 | Async構造体で非同期関数定義 | E-01 (lines 25-66) | ○ |
| C-03 | default_permission定数定義 | E-01 (lines 9-17) | ○ |
| C-04 | NewAsyncFSTaskで非同期タスク生成 | E-01 (lines 336-442) | ○ |
| C-05 | NewUVFSRequestでWindows対応 | E-01 (lines 114-334) | ○ |
| C-06 | WorkPoolでスレッドプール実行 | E-01 (lines 372-373) | ○ |
| C-07 | AbortSignal対応（readFile/writeFile） | E-01 (lines 68-71) | ○ |
| C-08 | eventLoop経由でコールバック | E-01 (lines 387, 273) | ○ |
| C-09 | libuv経由でWindows対応 | E-01 (lines 114-128) | ○ |
| C-10 | constants.zig定義あり | E-03 | ○ |
| C-11 | FSWatcher実装あり | E-04 | ○ |
| C-12 | StatWatcher実装あり | E-01 (line 7) | ○ |
| C-13 | AsyncCpTask（cpコマンド対応） | E-01 (lines 445-446) | ○ |
| C-14 | AsyncReaddirRecursiveTask | E-01 (lines 75) | ○ |
| C-15 | Node.js fs完全互換 | **根拠不足（部分的）** | △ |
| C-16 | createReadStream/WriteStream実装 | **根拠不足（JS側）** | △ |
| C-17 | fs/promises提供 | E-01 (非同期APIの存在から推測) | ○ |
| C-18 | Binding構造体でJS連携 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- Node.js fsモジュールとの完全な互換性リスト
  - 候補：互換性マトリックスまたはテストカバレッジ
- ストリームAPI（createReadStream等）の実装詳細
  - 候補：`src/js/node/fs.ts`内のストリーム実装

## 5) リスクフラグ（レビュー観点）
- 1: Node.js互換性の詳細確認が必要
- 1: Windows環境でのlibuv経由の動作確認推奨
- 0: 基本的なファイル操作は安定していると推測

## 6) レビュアーチェックリスト（最小）
- [ ] Node.js fs APIのカバレッジを確認
- [ ] Windows環境での動作テスト
- [ ] AbortSignal対応の動作確認
- [ ] 大規模ファイル処理時のパフォーマンス確認
