---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：90-node:crypto

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Node.js crypto完全互換性**：一部未実装APIの確認が必要
  2. **KeyObject内部実装**：C++側の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/bun.js/node/node_crypto_binding.zig` - Zig側バインディング（lines 1-500読込）
- E-02: `src/js/node/crypto.ts` - JavaScript側実装（lines 1-500読込）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExternCryptoJob関数でC++ジョブをZigで扱う | E-01 (lines 1-87) | ○ |
| C-02 | 各種CryptoJob定義（CheckPrime等） | E-01 (lines 90-114) | ○ |
| C-03 | CryptoJob関数（Zig定義ジョブ用） | E-01 (lines 116-184) | ○ |
| C-04 | randomInt関数 | E-01 (lines 218-265) | ○ |
| C-05 | randomUUID関数 | E-01 (lines 267-290) | ○ |
| C-06 | randomBytes関数 | E-01 (lines 320-346) | ○ |
| C-07 | randomFillSync/randomFill関数 | E-01 (lines 348-421) | ○ |
| C-08 | pbkdf2/pbkdf2Sync関数 | E-01 (lines 424-448) | ○ |
| C-09 | timingSafeEqual関数（定数時間比較） | E-01 (lines 450-468) | ○ |
| C-10 | getFips関数（常に0を返す） | E-01 (lines 474-476) | ○ |
| C-11 | Sign/Verifyクラス | E-02 (lines 189-251) | ○ |
| C-12 | Hash/Hmacクラス | E-02 (lines 254-328) | ○ |
| C-13 | Cipheriv/Decipherivクラス | E-02 (lines 449-495) | ○ |
| C-14 | BoringSSL使用 | E-01 (lines 442-443: BoringSSL.ERR_*) | ○ |
| C-15 | WorkPool使用（非同期処理） | E-01 (lines 76-79, 180-182) | ○ |
| C-16 | bun.csprng使用（乱数生成） | E-01 (lines 200, 333, 373) | ○ |
| C-17 | Node.js crypto完全互換 | **根拠不足（部分的）** | △ |
| C-18 | KeyObject詳細実装 | **根拠不足（C++側）** | △ |

## 4) 不足情報（Unknown / Missing）
- Node.js cryptoモジュールとの完全な互換性リスト
  - 候補：互換性マトリックスまたはテストカバレッジ
- KeyObjectの内部実装詳細
  - 候補：`src/bun.js/bindings/node_crypto_binding.cpp`

## 5) リスクフラグ（レビュー観点）
- 1: セキュリティ関連機能のため、実装の正確性確認が重要
- 1: Node.js互換性の詳細確認が必要
- 0: BoringSSLを使用しており暗号プリミティブは信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] Node.js crypto APIのカバレッジを確認
- [ ] timingSafeEqualの実装が本当に定数時間か確認
- [ ] 鍵データのメモリ保護を確認
- [ ] scrypt/pbkdf2のパラメータ上限を確認
