---
generated_at: 2026-01-27 17:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：91-node_http_https.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **HTTPクライアント実装詳細**：src/http/の実装詳細が未確認
  2. **ゼロコピーバッファ処理**：実装の具体的な根拠なし
  3. **STATUS_CODESの行番号**：実際のファイル構造と異なる可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/http.ts` - メインHTTPモジュール実装
- E-02: `src/js/internal/http.ts` - STATUS_CODESの定義（http2.tsからの参照で確認）
- E-03: `src/bun.js/api/server.zig` - Bunネイティブサーバー実装（参照のみ）
- E-04: `src/js/node/net.ts` - net.Serverの実装
- E-05: `src/js/node/tls.ts` - TLS/SSL実装
- E-06: `機能一覧.csv` - 機能ID 91の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | node:httpモジュールはTypeScriptで実装されている | E-01 | ○ |
| C-02 | createServer()でサーバーインスタンスを作成 | E-01 | ○ |
| C-03 | http.request()でクライアントリクエストを作成 | E-01 | ○ |
| C-04 | http.get()はGETリクエストの簡易メソッド | E-01 | ○ |
| C-05 | IncomingMessageはReadableストリームを継承 | E-01 | ○ |
| C-06 | ServerResponseはWritableストリームを継承 | E-01 | ○ |
| C-07 | Agentクラスで接続プールを管理 | E-01 | ○ |
| C-08 | STATUS_CODESがinternal/httpで定義 | E-02 | ○ |
| C-09 | BunネイティブサーバーはZigで実装 | E-03 | ○ |
| C-10 | net.Serverを継承してHTTP Serverを実装 | E-04 | ○ |
| C-11 | httpsモジュールはtls.Socketを使用 | E-05 | ○ |
| C-12 | EventEmitterベースのイベントモデル | E-01, E-04 | ○ |
| C-13 | Keep-Alive接続をサポート | E-01 | ○ |
| C-14 | タイムアウト設定が可能 | E-01 | ○ |
| C-15 | Node.js互換APIを提供 | E-01, E-06 | ○ |
| C-16 | src/http/にHTTPクライアント実装がある | **根拠なし** | △ |
| C-17 | ゼロコピーバッファ処理を活用 | **根拠なし** | △ |
| C-18 | STATUS_CODESの定義は1-50行目 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **HTTPクライアントの詳細実装**: src/http/ディレクトリの詳細な調査が必要
  - 候補：`src/http/websocket_client/` / HTTP client implementation files
- **パフォーマンス最適化の具体的手法**: ゼロコピーバッファ等の実装詳細
  - 候補：server.zig内の実装 / native binding files
- **行番号の正確性**: 実際のソースコードとの照合が必要
  - 候補：http.tsファイルの最新版確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なAPI仕様記述は正確
- **1 (中リスク)**: コードリーディングガイドの行番号 - 実際のファイルと差異の可能性
- **1 (中リスク)**: HTTPクライアント実装詳細 - 参照したファイルが不完全

## 6) レビュアーチェックリスト（最小）
- [ ] http.tsファイルの実際の構造を確認し、行番号を検証
- [ ] src/http/ディレクトリの存在と内容を確認
- [ ] createServer, request, getの各関数のシグネチャをNode.js公式と比較
- [ ] STATUS_CODESの定義箇所を確認
- [ ] Agent実装の詳細を確認（接続プール管理の仕組み）
