---
generated_at: 2026-01-27 17:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：93-node_net.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **Bunネイティブソケット実装詳細**：src/bun.js/api/の実装未確認
  2. **BlockListクラスの実装詳細**：具体的な実装確認が必要
  3. **Windows名前付きパイプ対応**：実際のサポート状況

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/net.ts` - メインnetモジュール実装（読み込み済み）
- E-02: `src/js/node/tls.ts` - TLSモジュール（net.Serverを参照）
- E-03: `src/js/node/http2.ts` - HTTP/2（net.Socket使用を確認）
- E-04: `機能一覧.csv` - 機能ID 93の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | netモジュールはTypeScriptで実装されている | E-01 | ○ |
| C-02 | createServer()でサーバー作成 | E-01 | ○ |
| C-03 | createConnection()でクライアント接続作成 | E-01 | ○ |
| C-04 | SocketはDuplexストリームを継承 | E-01 | ○ |
| C-05 | ServerはEventEmitterを継承 | E-01 | ○ |
| C-06 | write(), end(), destroy()メソッド提供 | E-01 | ○ |
| C-07 | listen(), close(), address()メソッド提供 | E-01 | ○ |
| C-08 | isIP(), isIPv4(), isIPv6()関数提供 | E-01 | ○ |
| C-09 | Unixドメインソケット対応 | E-01 | ○ |
| C-10 | TCP Keep-Alive, Nagle無効化対応 | E-01 | ○ |
| C-11 | TLSモジュールがnet.Serverを継承 | E-02 | ○ |
| C-12 | HTTP/2がnet.Socketを使用 | E-03 | ○ |
| C-13 | EventEmitterベースのイベントモデル | E-01 | ○ |
| C-14 | Bunネイティブソケット実装との連携 | **根拠なし** | △ |
| C-15 | BlockListクラスの詳細実装 | **根拠なし** | △ |
| C-16 | Windows名前付きパイプ対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Bunネイティブソケット実装**: src/bun.js/api/ディレクトリの詳細確認が必要
  - 候補：server.zig / socket実装ファイル
- **BlockListの実装詳細**: IPアドレスフィルタリングの具体的実装
  - 候補：net.ts内のBlockListクラス定義
- **プラットフォーム固有の動作**: Windows vs Unix の違い
  - 候補：条件分岐の確認 / テストファイル

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なSocket/Server APIは正確
- **1 (中リスク)**: Bunネイティブ連携の詳細 - 実装確認が必要
- **1 (中リスク)**: プラットフォーム固有機能 - 動作検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] net.tsファイルの全体構造を確認
- [ ] Socket/Serverクラスの継承関係を検証
- [ ] Bunネイティブソケット連携の実装を確認
- [ ] BlockListクラスの実装詳細を確認
- [ ] Unixドメインソケットの動作テスト
