---
generated_at: 2026-01-27 17:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：94-node_dgram.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **UDPネイティブ実装詳細**：dgram.tsの詳細構造
  2. **マルチキャスト実装**：addMembership等の具体的実装
  3. **IPv6デュアルスタック**：実際のサポート状況

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/dgram.ts` - メインdgramモジュール実装（ファイル読み込み済み）
- E-02: `src/js/node/events.ts` - EventEmitter基底クラス
- E-03: `機能一覧.csv` - 機能ID 94の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dgramモジュールはTypeScriptで実装 | E-01 | ○ |
| C-02 | createSocket()でソケット作成 | E-01 | ○ |
| C-03 | udp4/udp6タイプをサポート | E-01 | ○ |
| C-04 | bind(), send(), close()メソッド提供 | E-01 | ○ |
| C-05 | EventEmitterを継承 | E-01, E-02 | ○ |
| C-06 | messageイベントでデータ受信 | E-01 | ○ |
| C-07 | rinfoオブジェクトでアドレス情報提供 | E-01 | ○ |
| C-08 | addMembership()でマルチキャスト参加 | E-01 | ○ |
| C-09 | setBroadcast()でブロードキャスト有効化 | E-01 | ○ |
| C-10 | setMulticastTTL()でTTL設定 | E-01 | ○ |
| C-11 | ref()/unref()でイベントループ制御 | E-01 | ○ |
| C-12 | UDPネイティブ実装の詳細 | **根拠なし** | △ |
| C-13 | sendmsg()による複数バッファ送信 | **根拠なし** | △ |
| C-14 | IPv6デュアルスタック対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **UDPネイティブ実装**: Zigでの実装詳細が未確認
  - 候補：src/bun.js/内のUDP関連ファイル
- **マルチキャスト実装詳細**: setsockoptの具体的な呼び出し
  - 候補：dgram.ts内のネイティブ連携部分
- **プラットフォーム固有動作**: Windows/Linux/macOSでの違い
  - 候補：条件分岐の確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なSocket APIは正確
- **1 (中リスク)**: マルチキャスト機能 - 実装詳細の確認が必要
- **1 (中リスク)**: ネイティブ層連携 - 具体的な実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] dgram.tsファイルの全体構造を確認
- [ ] Socketクラスの継承関係を検証
- [ ] マルチキャスト機能の動作テスト
- [ ] ブロードキャスト機能の動作テスト
- [ ] IPv4/IPv6両方での動作確認
