---
generated_at: 2026-01-27 17:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：96-node_events.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **EventEmitterAsyncResource**：async_hooksとの統合詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/events.ts` - メインeventsモジュール実装（866行、全文読み込み済み）
- E-02: `src/js/node/events.ts:43-50` - シンボル定義（kCapture, kErrorMonitor等）
- E-03: `src/js/node/events.ts:58-78` - EventEmitterコンストラクタ
- E-04: `src/js/node/events.ts:160-237` - emit関数（emitWithout/WithRejectionCapture）
- E-05: `src/js/node/events.ts:241-287` - addListener, prependListener
- E-06: `src/js/node/events.ts:302-323` - once, _onceWrap
- E-07: `src/js/node/events.ts:332-363` - removeListener
- E-08: `src/js/node/events.ts:439-479` - once静的関数
- E-09: `src/js/node/events.ts:486-630` - on静的関数（AsyncIterator）
- E-10: `src/js/node/events.ts:791-812` - EventEmitterAsyncResource
- E-11: `機能一覧.csv` - 機能ID 96の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eventsモジュールはTypeScriptで実装 | E-01 | ○ |
| C-02 | defaultMaxListeners = 10 | E-01:55 | ○ |
| C-03 | kCapture, kErrorMonitor等のシンボル定義 | E-02 | ○ |
| C-04 | EventEmitterは標準関数として定義 | E-03 | ○ |
| C-05 | _events, _eventsCount, _maxListeners初期化 | E-03 | ○ |
| C-06 | on()でリスナー末尾に追加 | E-05 | ○ |
| C-07 | prependListener()でリスナー先頭に追加 | E-05 | ○ |
| C-08 | once()で一度だけ実行されるリスナー | E-06 | ○ |
| C-09 | emit()でイベント発行 | E-04 | ○ |
| C-10 | errorイベントのリスナーなしで例外スロー | E-04:96-135 | ○ |
| C-11 | removeListener()でリスナー削除 | E-07 | ○ |
| C-12 | listeners()でリスナー配列取得 | E-01:401-407 | ○ |
| C-13 | listenerCount()でリスナー数取得 | E-01:417-430 | ○ |
| C-14 | eventNames()でイベント名一覧取得 | E-01:433-435 | ○ |
| C-15 | newListenerイベントの発火 | E-05:247-248 | ○ |
| C-16 | removeListenerイベントの発火 | E-07:358 | ○ |
| C-17 | 静的once()でPromise待機 | E-08 | ○ |
| C-18 | 静的on()でAsyncIterator取得 | E-09 | ○ |
| C-19 | captureRejectionsでPromise rejection処理 | E-03, E-04 | ○ |
| C-20 | args.lengthに応じたcall/apply最適化 | E-04:177-191 | ○ |
| C-21 | MaxListenersExceededWarning警告 | E-01:289-300 | ○ |
| C-22 | EventEmitterAsyncResource実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **EventEmitterAsyncResource詳細**: async_hooksとの統合の具体的な実装
  - 候補：src/js/node/async_hooks.ts の確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: コアAPI（on, emit, once等）は正確に記述
- **0 (低リスク)**: 行番号は実際のソースコードと一致
- **0 (低リスク)**: 静的メソッドの仕様も正確

## 6) レビュアーチェックリスト（最小）
- [ ] events.tsの全体構造を確認（866行）
- [ ] emit関数の最適化パターンを検証
- [ ] once静的関数のAbortSignal処理を確認
- [ ] on静的関数のAsyncIterator動作を確認
- [ ] EventEmitterAsyncResourceの動作テスト
