---
generated_at: 2026-01-27 17:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：99-node_util.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **inspect関数の詳細実装**：internal/util/inspect.tsの詳細
  2. **util.typesの全関数**：types.tsの完全な関数一覧

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/util.ts` - メインutilモジュール実装（339行、全文読み込み済み）
- E-02: `src/bun.js/node/node_util_binding.zig` - ネイティブ実装（238行、全文読み込み済み）
- E-03: `src/js/node/util.ts:1-11` - インポート部分
- E-04: `src/js/node/util.ts:35-61` - debuglog実装
- E-05: `src/js/node/util.ts:63-104` - 型チェック関数
- E-06: `src/js/node/util.ts:148-193` - callbackify実装
- E-07: `src/js/node/util.ts:198-222` - styleText実装
- E-08: `src/js/node/util.ts:224-228` - getSystemErrorName
- E-09: `src/js/node/util.ts:240-283` - aborted実装
- E-10: `src/js/node/util.ts:285-338` - エクスポート
- E-11: `src/bun.js/node/node_util_binding.zig:1-99` - internalErrorName
- E-12: `src/bun.js/node/node_util_binding.zig:207-226` - parseEnv
- E-13: `機能一覧.csv` - 機能ID 99の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | util.tsはTypeScriptで実装 | E-01 | ○ |
| C-02 | internalErrorNameはZig関数 | E-03:10 | ○ |
| C-03 | parseEnvはZig関数 | E-03:11 | ○ |
| C-04 | parseArgsはZig関数 | E-01:28 | ○ |
| C-05 | debuglogでNODE_DEBUG環境変数確認 | E-04 | ○ |
| C-06 | isBoolean, isNull等の型チェック関数 | E-05 | ○ |
| C-07 | callbackifyでasync関数をコールバック化 | E-06 | ○ |
| C-08 | styleTextでANSIカラーコード適用 | E-07 | ○ |
| C-09 | getSystemErrorNameでエラーコード→名前変換 | E-08, E-11 | ○ |
| C-10 | abortedでAbortSignal待機 | E-09 | ○ |
| C-11 | format, formatWithOptionsをエクスポート | E-10 | ○ |
| C-12 | promisifyをエクスポート | E-10 | ○ |
| C-13 | inspectをエクスポート | E-10 | ○ |
| C-14 | isDeepStrictEqualをエクスポート | E-10:304 | ○ |
| C-15 | inheritsをエクスポート | E-10:302 | ○ |
| C-16 | deprecateをエクスポート | E-10:293 | ○ |
| C-17 | TextDecoder, TextEncoderをエクスポート | E-10:314-315 | ○ |
| C-18 | MIMEType, MIMEParamsをエクスポート | E-10:316-317 | ○ |
| C-19 | typesサブモジュールをエクスポート | E-10:311 | ○ |
| C-20 | internalErrorNameでエラーコードマッピング | E-11 | ○ |
| C-21 | parseEnvで環境変数形式解析 | E-12 | ○ |
| C-22 | deepEqualsはBun.deepEqualsを使用 | E-01:25-26 | ○ |
| C-23 | inspect関数の詳細実装 | **根拠なし** | △ |
| C-24 | util.typesの全関数一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **inspect関数の詳細実装**: internal/util/inspect.tsの内容
  - 候補：src/js/internal/util/inspect.ts
- **util.typesの全関数**: types.tsの完全な関数一覧
  - 候補：src/js/node/util/types.ts

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: util.tsのコア関数は正確に記述
- **0 (低リスク)**: Zig関数の呼び出しは正確
- **0 (低リスク)**: エクスポート一覧は正確

## 6) レビュアーチェックリスト（最小）
- [ ] util.tsの全体構造を確認（339行）
- [ ] node_util_binding.zigの全関数を確認
- [ ] internal/util/inspect.tsの実装を確認
- [ ] util/types.tsの全関数を確認
- [ ] promisifyの動作テスト
