---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 27
  claims_with_evidence: 25
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：25 / 27、根拠なし：2
- 優先レビュー（高）
  1. **repl**: 専用コマンドファイルが見つからず
  2. **feedback**: 専用コマンドファイルが見つからず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli.zig` - メインCLIエントリーポイント、Command.Tag enum定義
- E-02: `src/cli/run_command.zig` - runコマンド実装
- E-03: `src/cli/test_command.zig` - testコマンド実装
- E-04: `src/cli/bunx_command.zig` - bunxコマンド実装
- E-05: `src/cli/exec_command.zig` - execコマンド実装
- E-06: `src/cli/install_command.zig` - installコマンド実装
- E-07: `src/cli/add_command.zig` - addコマンド実装
- E-08: `src/cli/remove_command.zig` - removeコマンド実装
- E-09: `src/cli/update_command.zig` - updateコマンド実装
- E-10: `src/cli/audit_command.zig` - auditコマンド実装
- E-11: `src/cli/outdated_command.zig` - outdatedコマンド実装
- E-12: `src/cli/link_command.zig` - linkコマンド実装
- E-13: `src/cli/unlink_command.zig` - unlinkコマンド実装
- E-14: `src/cli/publish_command.zig` - publishコマンド実装
- E-15: `src/cli/patch_command.zig` - patchコマンド実装
- E-16: `src/cli/patch_commit_command.zig` - patch-commitコマンド実装
- E-17: `src/cli/package_manager_command.zig` - pmコマンド実装
- E-18: `src/cli/pm_view_command.zig` - infoコマンド実装
- E-19: `src/cli/why_command.zig` - whyコマンド実装
- E-20: `src/cli/build_command.zig` - buildコマンド実装
- E-21: `src/cli/init_command.zig` - initコマンド実装
- E-22: `src/cli/create_command.zig` - createコマンド実装
- E-23: `src/cli/upgrade_command.zig` - upgradeコマンド実装
- E-24: `src/cli/install_completions_command.zig` - completionsコマンド実装
- E-25: `src/cli/discord_command.zig` - discordコマンド実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | runコマンドがファイル/スクリプト実行に使用される | E-01, E-02 | ○ |
| C-02 | testコマンドがユニットテスト実行に使用される | E-01, E-03 | ○ |
| C-03 | x (bunx)コマンドがパッケージバイナリ実行に使用される | E-01, E-04 | ○ |
| C-04 | replコマンドがREPLセッション開始に使用される | E-01 | △ |
| C-05 | execコマンドがシェルスクリプト実行に使用される | E-01, E-05 | ○ |
| C-06 | installコマンドが依存関係インストールに使用される | E-01, E-06 | ○ |
| C-07 | addコマンドが依存関係追加に使用される | E-01, E-07 | ○ |
| C-08 | removeコマンドが依存関係削除に使用される | E-01, E-08 | ○ |
| C-09 | updateコマンドが依存関係更新に使用される | E-01, E-09 | ○ |
| C-10 | auditコマンドが脆弱性チェックに使用される | E-01, E-10 | ○ |
| C-11 | outdatedコマンドが古い依存関係表示に使用される | E-01, E-11 | ○ |
| C-12 | linkコマンドがローカルパッケージリンクに使用される | E-01, E-12 | ○ |
| C-13 | unlinkコマンドがローカルパッケージリンク解除に使用される | E-01, E-13 | ○ |
| C-14 | publishコマンドがパッケージ公開に使用される | E-01, E-14 | ○ |
| C-15 | patchコマンドがパッケージパッチ準備に使用される | E-01, E-15 | ○ |
| C-16 | patch-commitコマンドがパッチコミットに使用される | E-01, E-16 | ○ |
| C-17 | pmコマンドがパッケージ管理ユーティリティに使用される | E-01, E-17 | ○ |
| C-18 | infoコマンドがパッケージメタデータ表示に使用される | E-01, E-18 | ○ |
| C-19 | whyコマンドがインストール理由説明に使用される | E-01, E-19 | ○ |
| C-20 | buildコマンドがバンドルに使用される | E-01, E-20 | ○ |
| C-21 | initコマンドがプロジェクト初期化に使用される | E-01, E-21 | ○ |
| C-22 | createコマンドがテンプレートからプロジェクト作成に使用される | E-01, E-22 | ○ |
| C-23 | upgradeコマンドがBunアップグレードに使用される | E-01, E-23 | ○ |
| C-24 | helpコマンドがヘルプ表示に使用される | E-01 | ○ |
| C-25 | completionsコマンドがシェル補完インストールに使用される | E-01, E-24 | ○ |
| C-26 | discordコマンドがDiscordコミュニティアクセスに使用される | E-01, E-25 | ○ |
| C-27 | feedbackコマンドがフィードバック送信に使用される | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **repl**: `src/cli.zig`のCommand.Tag enumに`ReplCommand`として定義されているが、専用の実装ファイル(`repl_command.zig`)が見つからなかった。RunCommandまたは他のコードで実装されている可能性がある。
  - 候補：`src/cli/run_command.zig` / `src/bun.js/` / `src/repl/`
- **feedback**: ヘルプテキスト（cli_helptext_fmt）には記載されているが、Command.Tag enumに対応するコマンドが見つからなかった。外部URLへのリダイレクトの可能性がある。
  - 候補：Discord経由のフィードバック / GitHub Issues / 外部サービス

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大半のコマンドは対応するソースファイルで確認済み
- **1 (中リスク)**: replとfeedbackは実装の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] replコマンドの実装場所を確認する
- [ ] feedbackコマンドの動作を確認する（URLリダイレクトか、機能実装か）
- [ ] 各コマンドの説明文がヘルプテキストと一致しているか確認する
- [ ] エイリアス（bun i = bun install等）の網羅性を確認する
