# Bun CLI 画面遷移図

本ドキュメントはBun CLIの画面（コマンド）遷移を示します。

Bunはコマンドラインツールであるため、「画面」はCLIコマンドに相当します。ユーザーはターミナルからコマンドを入力し、各機能にアクセスします。

## 全体構成図

```mermaid
graph TD
    subgraph Entry["エントリーポイント"]
        BUN["bun"]
        BUNX["bunx"]
        NODE["node (互換モード)"]
    end

    subgraph Exec["実行コマンド"]
        RUN["run"]
        TEST["test"]
        X["x (bunx)"]
        REPL["repl"]
        EXEC["exec"]
    end

    subgraph PkgMgmt["パッケージ管理"]
        INSTALL["install"]
        ADD["add"]
        REMOVE["remove"]
        UPDATE["update"]
        AUDIT["audit"]
        OUTDATED["outdated"]
        LINK["link"]
        UNLINK["unlink"]
        PUBLISH["publish"]
        PATCH["patch"]
        PATCH_COMMIT["patch-commit"]
        PM["pm"]
        INFO["info"]
        WHY["why"]
    end

    subgraph Build["ビルドコマンド"]
        BUILD["build"]
    end

    subgraph Init["初期化/設定"]
        INIT["init"]
        CREATE["create"]
        UPGRADE["upgrade"]
    end

    subgraph Help["ヘルプ/補助"]
        HELP["help"]
        COMPLETIONS["completions"]
        DISCORD["discord"]
        FEEDBACK["feedback"]
    end

    BUN --> RUN
    BUN --> TEST
    BUN --> X
    BUN --> REPL
    BUN --> EXEC
    BUN --> INSTALL
    BUN --> ADD
    BUN --> REMOVE
    BUN --> UPDATE
    BUN --> AUDIT
    BUN --> OUTDATED
    BUN --> LINK
    BUN --> UNLINK
    BUN --> PUBLISH
    BUN --> PATCH
    BUN --> PATCH_COMMIT
    BUN --> PM
    BUN --> INFO
    BUN --> WHY
    BUN --> BUILD
    BUN --> INIT
    BUN --> CREATE
    BUN --> UPGRADE
    BUN --> HELP
    BUN --> COMPLETIONS
    BUN --> DISCORD
    BUN --> FEEDBACK

    BUNX --> X
    NODE --> RUN
```

## 実行コマンド遷移

```mermaid
graph LR
    subgraph RunGroup["実行コマンド"]
        RUN["bun run"]
        TEST["bun test"]
        X["bun x / bunx"]
        REPL["bun repl"]
        EXEC["bun exec"]
    end

    FILE["ファイル実行<br/>./script.ts"]
    SCRIPT["スクリプト実行<br/>package.json scripts"]
    TESTS["テスト実行<br/>*.test.ts"]
    PKG_BIN["パッケージバイナリ<br/>vite, prisma等"]
    REPL_SESSION["REPLセッション"]
    SHELL_SCRIPT["シェルスクリプト"]

    RUN --> FILE
    RUN --> SCRIPT
    TEST --> TESTS
    X --> PKG_BIN
    REPL --> REPL_SESSION
    EXEC --> SHELL_SCRIPT
```

## パッケージ管理遷移

```mermaid
graph LR
    subgraph PkgMgmtGroup["パッケージ管理"]
        INSTALL["bun install"]
        ADD["bun add"]
        REMOVE["bun remove"]
        UPDATE["bun update"]
    end

    subgraph PkgSubcmds["サブコマンド"]
        PM["bun pm"]
        AUDIT["bun audit"]
        OUTDATED["bun outdated"]
        WHY["bun why"]
        INFO["bun info"]
    end

    subgraph LinkGroup["リンク"]
        LINK["bun link"]
        UNLINK["bun unlink"]
    end

    subgraph PatchGroup["パッチ"]
        PATCH["bun patch"]
        PATCH_COMMIT["bun patch-commit"]
    end

    PUBLISH["bun publish"]

    PKG_JSON["package.json"]
    LOCK["bun.lockb"]
    NODE_MODULES["node_modules"]
    REGISTRY["npm registry"]

    INSTALL --> PKG_JSON
    INSTALL --> LOCK
    INSTALL --> NODE_MODULES
    ADD --> PKG_JSON
    ADD --> NODE_MODULES
    REMOVE --> PKG_JSON
    REMOVE --> NODE_MODULES
    UPDATE --> PKG_JSON
    UPDATE --> NODE_MODULES

    AUDIT --> REGISTRY
    OUTDATED --> REGISTRY
    INFO --> REGISTRY
    PUBLISH --> REGISTRY

    PATCH --> NODE_MODULES
    PATCH_COMMIT --> NODE_MODULES

    LINK --> NODE_MODULES
    UNLINK --> NODE_MODULES
```

## プロジェクト初期化遷移

```mermaid
graph LR
    INIT["bun init"]
    CREATE["bun create"]
    UPGRADE["bun upgrade"]

    TEMPLATE["テンプレート選択"]
    NEW_PROJECT["新規プロジェクト"]
    BUN_BINARY["Bunバイナリ"]

    INIT --> NEW_PROJECT
    CREATE --> TEMPLATE
    TEMPLATE --> NEW_PROJECT
    UPGRADE --> BUN_BINARY
```

## ビルド遷移

```mermaid
graph LR
    BUILD["bun build"]

    SRC["ソースファイル<br/>*.ts, *.tsx, *.js"]
    OUT["出力ファイル<br/>バンドル済み"]
    STANDALONE["スタンドアロン実行可能ファイル<br/>--compile"]

    SRC --> BUILD
    BUILD --> OUT
    BUILD --> STANDALONE
```

## 備考

- `bun` コマンドは引数なしで実行すると `help` を表示
- `bunx` は `bun x` のエイリアスとして動作
- `node` として呼び出された場合はNode.js互換モードで動作
- 各コマンドは `--help` フラグでヘルプを表示可能
