---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 82
  claims_with_evidence: 78
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピングの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：78 / 82、根拠なし：4
- 優先レビュー（高）
  1. **help画面の機能マッピング**：機能一覧に対応する機能エントリなし
  2. **completions画面の機能マッピング**：機能一覧に対応する機能エントリなし
  3. **discord画面の機能マッピング**：機能一覧に対応する機能エントリなし
  4. **feedback画面の機能マッピング**：機能一覧に対応する機能エントリなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`（27画面定義）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（116機能定義）
- E-03: `src/cli/run_command.zig`（runコマンド実装）
- E-04: `src/cli/test_command.zig`（testコマンド実装）
- E-05: `src/cli/bunx_command.zig`（bunxコマンド実装）
- E-06: `src/cli/install_command.zig`（installコマンド実装）
- E-07: `src/cli/add_command.zig`（addコマンド実装）
- E-08: `src/cli/remove_command.zig`（removeコマンド実装）
- E-09: `src/cli/update_command.zig`（updateコマンド実装）
- E-10: `src/cli/build_command.zig`（buildコマンド実装）
- E-11: `src/cli/init_command.zig`（initコマンド実装）
- E-12: `src/cli/create_command.zig`（createコマンド実装）
- E-13: `src/cli/upgrade_command.zig`（upgradeコマンド実装）
- E-14: `src/cli/patch_command.zig`（patchコマンド実装）
- E-15: `src/cli/patch_commit_command.zig`（patch-commitコマンド実装）
- E-16: `src/cli/link_command.zig`（linkコマンド実装）
- E-17: `src/cli/unlink_command.zig`（unlinkコマンド実装）
- E-18: `src/cli/publish_command.zig`（publishコマンド実装）
- E-19: `src/cli/audit_command.zig`（auditコマンド実装）
- E-20: `src/cli/outdated_command.zig`（outdatedコマンド実装）
- E-21: `src/cli/why_command.zig`（whyコマンド実装）
- E-22: `src/cli/package_manager_command.zig`（pmコマンド実装）
- E-23: `src/cli/pm_view_command.zig`（pm viewコマンド実装）
- E-24: `src/cli/exec_command.zig`（execコマンド実装）
- E-25: `src/cli/install_completions_command.zig`（completionsコマンド実装）
- E-26: `src/cli/discord_command.zig`（discordコマンド実装）
- E-27: `src/cli.zig`（CLIメインエントリポイント）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | run画面とJavaScript/TypeScript実行機能の関連 | E-01, E-02, E-03 | ○ |
| C-02 | run画面とモジュール解決機能の関連 | E-01, E-02, E-03 | ○ |
| C-03 | run画面とトランスパイラ機能の関連 | E-01, E-02, E-03 | ○ |
| C-04 | run画面とホットリロード機能の関連 | E-01, E-02, E-03 | ○ |
| C-05 | run画面と環境変数機能の関連 | E-01, E-02, E-03 | ○ |
| C-06 | run画面とプラグインシステム機能の関連 | E-01, E-02, E-03 | ○ |
| C-07 | run画面とbunfig.toml設定機能の関連 | E-01, E-02, E-03 | ○ |
| C-08 | run画面とbun run機能の関連 | E-01, E-02, E-03 | ○ |
| C-09 | test画面とbun test機能の関連 | E-01, E-02, E-04 | ○ |
| C-10 | test画面とJest互換テスト機能の関連 | E-01, E-02, E-04 | ○ |
| C-11 | test画面とスナップショットテスト機能の関連 | E-01, E-02, E-04 | ○ |
| C-12 | test画面とモック機能の関連 | E-01, E-02, E-04 | ○ |
| C-13 | test画面とコードカバレッジ機能の関連 | E-01, E-02, E-04 | ○ |
| C-14 | test画面とWatchモード機能の関連 | E-01, E-02, E-04 | ○ |
| C-15 | test画面とJUnitレポート機能の関連 | E-01, E-02, E-04 | ○ |
| C-16 | test画面とDOMテスト機能の関連 | E-01, E-02, E-04 | ○ |
| C-17 | bunx画面とbunx機能の関連 | E-01, E-02, E-05 | ○ |
| C-18 | bunx画面と依存関係解決機能の関連 | E-01, E-02, E-05 | ○ |
| C-19 | bunx画面とnpmレジストリ機能の関連 | E-01, E-02, E-05 | ○ |
| C-20 | repl画面とREPL機能の関連 | E-01, E-02 | ○ |
| C-21 | repl画面とJavaScript/TypeScript実行機能の関連 | E-01, E-02 | ○ |
| C-22 | exec画面とbun exec機能の関連 | E-01, E-02, E-24 | ○ |
| C-23 | exec画面と$シェル機能の関連 | E-01, E-02, E-24 | ○ |
| C-24 | install画面とbun install機能の関連 | E-01, E-02, E-06 | ○ |
| C-25 | install画面と依存関係解決機能の関連 | E-01, E-02, E-06 | ○ |
| C-26 | install画面とロックファイル機能の関連 | E-01, E-02, E-06 | ○ |
| C-27 | install画面とnpmレジストリ機能の関連 | E-01, E-02, E-06 | ○ |
| C-28 | install画面とグローバルキャッシュ機能の関連 | E-01, E-02, E-06 | ○ |
| C-29 | install画面とワークスペース機能の関連 | E-01, E-02, E-06 | ○ |
| C-30 | install画面とライフサイクルスクリプト機能の関連 | E-01, E-02, E-06 | ○ |
| C-31 | install画面とpnpm互換機能の関連 | E-01, E-02, E-06 | ○ |
| C-32 | install画面とyarn互換機能の関連 | E-01, E-02, E-06 | ○ |
| C-33 | add画面とbun add機能の関連 | E-01, E-02, E-07 | ○ |
| C-34 | add画面と依存関係解決機能の関連 | E-01, E-02, E-07 | ○ |
| C-35 | add画面とnpmレジストリ機能の関連 | E-01, E-02, E-07 | ○ |
| C-36 | add画面とロックファイル機能の関連 | E-01, E-02, E-07 | ○ |
| C-37 | remove画面とbun remove機能の関連 | E-01, E-02, E-08 | ○ |
| C-38 | remove画面とロックファイル機能の関連 | E-01, E-02, E-08 | ○ |
| C-39 | update画面とbun update機能の関連 | E-01, E-02, E-09 | ○ |
| C-40 | update画面と依存関係解決機能の関連 | E-01, E-02, E-09 | ○ |
| C-41 | update画面とnpmレジストリ機能の関連 | E-01, E-02, E-09 | ○ |
| C-42 | update画面とロックファイル機能の関連 | E-01, E-02, E-09 | ○ |
| C-43 | audit画面とbun audit機能の関連 | E-01, E-02, E-19 | ○ |
| C-44 | audit画面とnpmレジストリ機能の関連 | E-01, E-02, E-19 | ○ |
| C-45 | outdated画面とbun outdated機能の関連 | E-01, E-02, E-20 | ○ |
| C-46 | outdated画面とnpmレジストリ機能の関連 | E-01, E-02, E-20 | ○ |
| C-47 | link画面とbun link機能の関連 | E-01, E-02, E-16 | ○ |
| C-48 | link画面とグローバルキャッシュ機能の関連 | E-01, E-02, E-16 | ○ |
| C-49 | unlink画面とbun unlink機能の関連 | E-01, E-02, E-17 | ○ |
| C-50 | publish画面とbun publish機能の関連 | E-01, E-02, E-18 | ○ |
| C-51 | publish画面とnpmレジストリ機能の関連 | E-01, E-02, E-18 | ○ |
| C-52 | patch画面とbun patch機能の関連 | E-01, E-02, E-14 | ○ |
| C-53 | patch画面とパッチ管理機能の関連 | E-01, E-02, E-14 | ○ |
| C-54 | patch-commit画面とbun patch-commit機能の関連 | E-01, E-02, E-15 | ○ |
| C-55 | patch-commit画面とパッチ管理機能の関連 | E-01, E-02, E-15 | ○ |
| C-56 | pm画面とbun pm機能の関連 | E-01, E-02, E-22 | ○ |
| C-57 | pm画面とグローバルキャッシュ機能の関連 | E-01, E-02, E-22 | ○ |
| C-58 | info画面とbun pm機能の関連 | E-01, E-02, E-23 | ○ |
| C-59 | info画面とnpmレジストリ機能の関連 | E-01, E-02, E-23 | ○ |
| C-60 | why画面とbun why機能の関連 | E-01, E-02, E-21 | ○ |
| C-61 | why画面と依存関係解決機能の関連 | E-01, E-02, E-21 | ○ |
| C-62 | build画面とbun build機能の関連 | E-01, E-02, E-10 | ○ |
| C-63 | build画面とJavaScriptバンドル機能の関連 | E-01, E-02, E-10 | ○ |
| C-64 | build画面とツリーシェイキング機能の関連 | E-01, E-02, E-10 | ○ |
| C-65 | build画面とコード分割機能の関連 | E-01, E-02, E-10 | ○ |
| C-66 | build画面とCSSバンドル機能の関連 | E-01, E-02, E-10 | ○ |
| C-67 | build画面とHTMLバンドル機能の関連 | E-01, E-02, E-10 | ○ |
| C-68 | build画面と単一実行ファイル機能の関連 | E-01, E-02, E-10 | ○ |
| C-69 | build画面とソースマップ機能の関連 | E-01, E-02, E-10 | ○ |
| C-70 | build画面とマクロ機能の関連 | E-01, E-02, E-10 | ○ |
| C-71 | build画面とローダー機能の関連 | E-01, E-02, E-10 | ○ |
| C-72 | init画面とbun init機能の関連 | E-01, E-02, E-11 | ○ |
| C-73 | init画面とbunfig.toml設定機能の関連 | E-01, E-02, E-11 | ○ |
| C-74 | create画面とbun create機能の関連 | E-01, E-02, E-12 | ○ |
| C-75 | create画面とnpmレジストリ機能の関連 | E-01, E-02, E-12 | ○ |
| C-76 | create画面と依存関係解決機能の関連 | E-01, E-02, E-12 | ○ |
| C-77 | upgrade画面とbun upgrade機能の関連 | E-01, E-02, E-13 | ○ |
| C-78 | completions画面とシェル補完機能の関連 | E-01, E-25 | ○ |
| C-79 | help画面のヘルプ表示機能 | E-01, E-27 | △ |
| C-80 | completions画面のシェル補完機能 | E-01, E-25 | △ |
| C-81 | discord画面のDiscord連携機能 | E-01, E-26 | △ |
| C-82 | feedback画面のフィードバック機能 | E-01 | △ |

## 4) 不足情報（Unknown / Missing）
- **help、completions、discord、feedback画面の機能エントリ**：機能一覧.csvにこれらの画面専用の機能エントリが定義されていないため、機能Noを空欄としています
  - 候補：機能一覧への追加 / ヘルプ・補助カテゴリの機能定義 / 画面一覧からの除外検討

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**：大多数のマッピング（78件）はソースコードと既存ドキュメントから明確に導出可能
- **1（中リスク）**：4件のヘルプ・補助系画面は機能一覧との対応が不明確だが、画面自体は単純な動作のため影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面と機能の関連が実装コードと一致しているか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] 「関連する操作・処理」の説明が実際の動作を正確に表しているか確認
- [ ] help、completions、discord、feedback画面の機能マッピングを補完するか、機能一覧への追加を検討
- [ ] 画面一覧の全27画面がマッピングされているか確認
