# 画面設計書 1-run

## 概要

本ドキュメントは、Bun CLIの`run`コマンドの設計仕様を記述する。`bun run`コマンドは、JavaScript/TypeScriptファイルの直接実行、またはpackage.jsonに定義されたスクリプトの実行を行うBunの中核機能である。

### 本画面の処理概要

`bun run`コマンドは、Bunランタイムの主要なエントリーポイントとして、開発者がJavaScript/TypeScriptコードを高速に実行するための機能を提供する。

**業務上の目的・背景**：現代のJavaScript/TypeScript開発において、コードの実行は最も頻繁に行われる操作である。従来のNode.jsに比べて高速な起動時間と実行速度を実現し、開発者の生産性を向上させる。また、package.jsonのスクリプト実行機能により、プロジェクト固有のビルド・テスト・デプロイコマンドを統一的に管理・実行できる。

**画面へのアクセス方法**：ターミナルから以下のコマンドで実行する。
- `bun run <file>` - ファイルを直接実行
- `bun run <script>` - package.jsonスクリプトを実行
- `bun <file>` - runを省略してファイル実行（暗黙的なrun）

**主要な操作・処理内容**：
1. コマンドライン引数の解析と実行モードの判定（ファイル実行/スクリプト実行）
2. package.jsonスクリプト実行時のpre/postスクリプト自動実行
3. 環境変数（.envファイル）の自動読み込み
4. モジュール解決とトランスパイル（TypeScript/JSX対応）
5. --watchオプションによるホットリロード対応
6. --bunオプションによるBunランタイム強制使用

**画面遷移**：
- エントリーポイント：`bun` コマンドから直接遷移
- 遷移先：実行完了後はターミナルに制御を返す
- 関連コマンド：`bun test`（テスト実行）、`bun build`（ビルド）

**権限による表示制御**：特になし。ファイルシステムの読み取り権限に依存。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | JavaScript/TypeScript実行 | 主機能 | ファイル実行時のJavaScript/TypeScriptコードの解釈と実行 |
| 2 | モジュール解決 | 主機能 | importやrequireによるモジュールの解決処理 |
| 3 | トランスパイラ | 主機能 | TypeScript、JSX、TSXの実行時トランスパイル |
| 4 | ホットリロード | 補助機能 | --watchや--hotオプションによるファイル変更検知と自動再起動 |
| 6 | 環境変数 | 補助機能 | .envファイルの読み込みとprocess.envへの設定 |
| 7 | プラグインシステム | 補助機能 | Bun.plugin()によるカスタムローダーの適用 |
| 8 | bunfig.toml設定 | 補助機能 | 設定ファイルからの実行オプション読み込み |
| 9 | bun run | 主機能 | package.jsonスクリプトまたはファイルの実行コマンド処理 |

## 画面種別

コマンドラインインターフェース（CLI）- 実行コマンド

## URL/ルーティング

コマンドラインパターン:
- `bun run [flags] <file-or-script> [args...]`
- `bun [flags] <file> [args...]`（暗黙的run）

## 入出力項目

### 入力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| file-or-script | string | Yes | 実行するファイルパスまたはpackage.jsonスクリプト名 |
| --watch / -w | flag | No | ファイル変更時に自動再起動 |
| --hot | flag | No | ホットモジュールリプレースメント有効化 |
| --bun | flag | No | Bunランタイムを強制使用 |
| --silent | flag | No | 出力を抑制 |
| --env-file | string | No | 読み込む.envファイルを指定 |
| --if-present | flag | No | スクリプトが存在しない場合もエラーにしない |
| [args...] | string[] | No | 実行スクリプトに渡す引数 |

### 出力項目

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | stream | 実行スクリプトの標準出力 |
| stderr | stream | 実行スクリプトの標準エラー出力 |
| exit code | number | 終了コード（0: 成功、非0: エラー） |

## 表示項目

| 項目名 | 表示条件 | 説明 |
|--------|----------|------|
| スクリプト実行ログ | --silent未指定時 | 実行されるコマンドの表示 |
| エラーメッセージ | エラー発生時 | スタックトレースを含むエラー詳細 |
| ヘルプテキスト | --help指定時 | コマンドの使用方法 |

## イベント仕様

### 1-ファイル実行

ユーザーがファイルパスを指定して`bun run`を実行した場合の処理フロー：

1. コマンドライン引数を解析
2. ファイルの存在確認とローダー判定
3. Bunfig設定の読み込み
4. 環境変数（.env）の読み込み
5. JavaScriptCore VMの初期化
6. ファイルのトランスパイルと実行
7. 終了コードを返却

### 2-スクリプト実行

ユーザーがpackage.jsonスクリプト名を指定した場合の処理フロー：

1. package.jsonの検索と読み込み
2. scriptsセクションから該当スクリプトを検索
3. pre{script}の存在確認と実行
4. メインスクリプトの実行
5. post{script}の存在確認と実行
6. 終了コードを返却

### 3-ホットリロード

--watchオプション指定時の処理フロー：

1. ファイルウォッチャーの初期化
2. 初回実行
3. ファイル変更検知時にプロセス再起動
4. Ctrl+Cで終了

## データベース更新仕様

本コマンドはデータベースを使用しない。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|---------------|----------|
| ERR_FILE_NOT_FOUND | error | Module not found "{file}" | 指定ファイルが存在しない |
| ERR_SCRIPT_NOT_FOUND | error | Script not found "{script}" | package.jsonにスクリプトが存在しない |
| ERR_NO_PACKAGE_JSON | warning | No package.json found | package.jsonが見つからない |
| ERR_EXECUTION | error | Failed to run "{file}" due to error {error} | 実行時エラー |
| ERR_EXIT_CODE | error | script "{name}" exited with code {code} | 非0終了コード |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|---------|----------|---------|
| ファイル不在 | 指定ファイルが存在しない | エラーメッセージを表示し終了コード1で終了 |
| 構文エラー | JavaScript/TypeScriptの構文エラー | パースエラーを表示し終了コード1で終了 |
| 実行時エラー | 実行中の例外 | スタックトレースを表示し終了コード1で終了 |
| シグナル受信 | SIGINT/SIGTERM | プロセスを終了 |

## 備考

- `bun run`は他のパッケージマネージャー（npm、yarn、pnpm）の`run`コマンドとの互換性を持つ
- package.jsonスクリプト内の`npm run`、`yarn run`、`pnpm run`は自動的に`bun run`に置換される
- Windows環境では`cmd.exe`を使用したシステムシェル実行も可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コマンド実行時に使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cli.zig | `src/cli.zig` | Command.Context構造体とDebugOptions、RuntimeOptionsの定義を確認 |
| 1-2 | Arguments.zig | `src/cli/Arguments.zig` | コマンドライン引数のパース定義 |

**読解のコツ**: Zigでは構造体のフィールドがそのままオプションの定義となる。`DebugOptions`の`hot_reload`フィールドなどがCLIオプションに対応。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | run_command.zig | `src/cli/run_command.zig` | RunCommand構造体のexec関数がエントリーポイント |

**主要処理フロー**:
1. **行1325-1626**: `exec`関数 - メインの実行ロジック
2. **行1339-1346**: 引数解析とターゲット名の取得
3. **行1371**: ファイル直接実行の試行（maybeOpenWithBunJS）
4. **行1435-1495**: package.jsonスクリプトの検索と実行

#### Step 3: スクリプト実行処理を理解する

package.jsonスクリプト実行の詳細処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | run_command.zig | `src/cli/run_command.zig` | runPackageScriptForeground関数 |

**主要処理フロー**:
- **行208-367**: `runPackageScriptForeground` - シェルコマンドの実行
- **行219**: シェルの検索（findShell）
- **行230**: npm/yarn/pnpmコマンドのbunへの置換
- **行248-267**: Bunのシェルインタプリタを使用した実行

#### Step 4: 環境設定処理を理解する

環境変数とPATH設定の処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | run_command.zig | `src/cli/run_command.zig` | configureEnvForRun, configurePathForRun関数 |

**主要処理フロー**:
- **行771-867**: `configureEnvForRun` - 環境変数の設定
- **行959-979**: `configurePathForRun` - PATH環境変数の設定
- **行642-767**: `createFakeTemporaryNodeExecutable` - node互換シンボリックリンクの作成

### プログラム呼び出し階層図

```
RunCommand.exec()
    |
    +-- maybeOpenWithBunJS()
    |       +-- Run.boot()  (ファイル直接実行)
    |
    +-- configureEnvForRun()
    |       +-- Transpiler.init()
    |       +-- runEnvLoader()
    |
    +-- configurePathForRun()
    |       +-- createFakeTemporaryNodeExecutable()
    |
    +-- runPackageScriptForeground()  (スクリプト実行)
    |       +-- findShell()
    |       +-- replacePackageManagerRun()
    |       +-- shell.Interpreter.initAndRunFromSource()
    |
    +-- runBinary()  (バイナリ実行)
            +-- spawnSync()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 -----> Arguments.parse() -----> Context構造体
        |
        v
package.json ---------> スクリプト検索 ---------> スクリプト内容
        |
        v
.env ファイル ---------> env_loader ---------> 環境変数Map
        |
        v
ソースファイル ---------> Transpiler ---------> 実行可能コード
        |
        v
                        JavaScriptCore VM ---------> stdout/stderr/exit code
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| run_command.zig | `src/cli/run_command.zig` | ソース | runコマンドのメイン実装 |
| cli.zig | `src/cli.zig` | ソース | CLIコマンドの定義とディスパッチ |
| Arguments.zig | `src/cli/Arguments.zig` | ソース | コマンドライン引数パーサー |
| env_loader.zig | `src/env_loader.zig` | ソース | .envファイル読み込み |
| transpiler.zig | `src/transpiler.zig` | ソース | TypeScript/JSXトランスパイラ |
| resolver/package_json.zig | `src/resolver/package_json.zig` | ソース | package.json解析 |
| shell/interpreter.zig | `src/shell/interpreter.zig` | ソース | シェルコマンド実行 |
| bun_js/run.zig | `src/bun.js/run.zig` | ソース | JavaScriptCore VM起動 |
